% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{raintrees}
\alias{raintrees}
\title{Rainforest tree data 1.}
\format{
A \code{ppp} object (see package \code{spatstat}) with 7251 points, containing:
\describe{
\item{window}{An object of type \code{owin} (see package \code{spatstat}), the 1000x500 metres observation area}
\item{x, y}{Numeric vectors with points' coordinates}
\item{marks}{A character vector matching the tree species to the data points}
}
}
\source{
http://www.ctfs.si.edu
}
\usage{
raintrees
}
\description{
A marked point pattern dataset about four rainforest tree species:
Acalypha diversifolia, Chamguava schippii,
Inga pezizifera and Rinorea sylvatica
}
\details{
This dataset documents the presence of tree species over Barro Colorado Island, Panama.
Barro Colorado Island has been the focus of intensive research on lowland tropical
rainforest since 1923 (http://www.ctfs.si.edu). Research identified several tree species
over a rectangular observation window of size 1000x500 metres; the tree species
constitute the point data categorical mark. This dataset presents 4 species with
different spatial configurations: Acalypha diversifolia, Chamguava schippii,
Inga pezizifera and Rinorea sylvatica. The overall dataset has a total number of 7251 points.
The dataset is analyzed with spatial entropy measures in Altieri et al (2018) (references can be
found at \code{SpatEntropy}).
}
\examples{
data(raintrees)
#plot(raintrees, main="", pch=16, cols=1:4)

#shannon's entropy of the four trees
shannon(raintrees)

#shannon's entropy of Z (tree pairs)
shannonZ(raintrees)

#leibovici's entropy
raintrees$window #to check size and unit of measurement
#example run on a subset of the data to speed up computations
subdata=raintrees[owin(c(0,200),c(0,100))]; plot(subdata)
outp=leibovici(subdata, ccdist=10, verbose=TRUE)
#do not worry about warnings like "data contain duplicated points": since
#coordinates are rounded to the first decimal place, it looks like
#some trees are overlapping when they are just very close.
#Entropy computation works properly anyway

#altieri's entropy
#example run on a subset of the data to speed up computations
subdata=raintrees[owin(c(0,200),c(0,100))]; plot(subdata)
outp=altieri(subdata, distbreak=c(1,2,5,10), verbose=TRUE)

#batty's entropy
#on all points, with a random partition in 10 sub-areas
batty.ent=batty(unmark(raintrees), partition=10)
#plot with partition
#plot(unmark(raintrees), pch=16, cex=0.6, main="")
#plot(batty.ent$area.tess, add=TRUE, border=2, lwd=2)
#on a specific tree species, with a random partition in 6 sub-areas
unique(marks(raintrees)) #to check the species' names
#plot(split.ppp(raintrees), main="") #to plot by species
batty.ent=batty(raintrees, category="cha2sc", partition=6)
#plot with partition
#plot(split.ppp(raintrees)$cha2sc, pch=16, cex=0.6, main="")
#plot(batty.ent$area.tess, add=TRUE, border=2)

#batty's entropy with a partition based on the covariate,
#exploiting spatstat functions
data(raintreesCOV)
#plot(raintreesCOV$grad, main="", col=gray(seq(1,0,l=100)))
data=split.ppp(raintrees)$acaldi
#plot(data, add=TRUE, pch=16, cex=0.6, main="")
#discretize the covariate
slopecut=cut(raintreesCOV$grad,
                breaks = quantile(raintreesCOV$grad, probs = (0:4)/4),
                labels = 1:4)
maskv=tiles=list()
for(ii in 1:nlevels(slopecut))
{
maskv[[ii]]=as.logical(c(slopecut$v)==levels(slopecut)[ii])
tiles[[ii]]=owin(xrange=data$window$xrange,
                 yrange=data$window$yrange,
                 mask=matrix(maskv[[ii]],nrow(slopecut$v)))
}
slopetess=list(tiles=tiles, n=nlevels(slopecut))
#plot(slopecut, main = "", col=gray(seq(1,0.4,l=4)))
#plot(data, add=TRUE, pch=16, cex=0.6, main="", col=1)

batty(data, partition=slopetess)

#karlstrom and ceccato's entropy
#on a specific tree species, with a random partition in 6 sub-areas
unique(marks(raintrees)) #to check the species' names
#plot(split.ppp(raintrees), main="") #to plot by species
KC.ent=karlstrom(raintrees, category="rinosy", partition=6, neigh=3)
#plot with partition
#plot(split.ppp(raintrees)$rinosy, pch=16, cex=0.6, main="")
#plot(KC.ent$area.tess, add=TRUE, border=2)
}
\keyword{datasets}
