% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsemdc_gap.R
\name{sparsemdc_gap}
\alias{sparsemdc_gap}
\title{Gap Statistic Calculator}
\usage{
sparsemdc_gap(pdat, dim, min_clus, max_clus, nboots = 200, nitter = 20,
  nstarts = 10, l1_boot = 50, l2_boot = 50)
}
\arguments{
\item{pdat}{list with D entries, each entry contains data d, p * n matrix.
This data should be centered and log-transformed.}

\item{dim}{Total number of conditions, D.}

\item{min_clus}{The minimum number of clusters to try, minimum value is 2.}

\item{max_clus}{The maximum number of clusters to try.}

\item{nboots}{The number of bootstrap repetitions to use, default = 200.}

\item{nitter}{The max number of iterations for each of the start values, the
default value is 20.}

\item{nstarts}{The number of start values to use for SparseDC. The default
value is 10.}

\item{l1_boot}{The number of bootstrap repetitions used for estimating
lambda 1.}

\item{l2_boot}{The number of bootstrap repetitions used for estimating
lambda 2.}
}
\value{
A list containing the optimal number of clusters, as well as gap
statistics and the calculated standard error for each number of clusters.
}
\description{
This function calculates the gap statistic for SparseMDC. For use
when the number of clusters in the data is unknown. We recommend
using alternate methods to infer the number of clusters in the
data.
}
\examples{
set.seed(10)
# Select small dataset for example
data_test <- data_biase[1:100,]
# Split data into condition A and B
data_A <- data_test[ , which(condition_biase == "A")]
data_B <- data_test[ , which(condition_biase == "B")]
data_C <- data_test[ , which(condition_biase == "C")]
# Store data as list
dat_l <- list(data_A, data_B, data_C)
# Pre-process the data
pdat <- pre_proc_data(dat_l, dim=3, norm = FALSE, log = TRUE,
center = TRUE)
# Run with one bootstrap sample for example
gap_stat <- sparsemdc_gap(pdat, dim=3, min_clus = 2, max_clus =3, nboots =2,
nitter = 2, nstarts = 1, l1_boot = 5, l2_boot = 5)

}
