% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{Find_regional_IDs}
\alias{Find_regional_IDs}
\title{Find the spatial neighborhood Spot IDs}
\usage{
Find_regional_IDs(
  object,
  spatial_coord,
  centerID,
  enhanced = FALSE,
  radius,
  unitDist
)
}
\arguments{
\item{object}{An object that could be either 1. A Seurat object, or 2. A data frame where the columns are Spot_IDs (i.e., the gene*spot expression matrix).}

\item{spatial_coord}{A data frame of the spatial coordinates. The column names should include `c("Spot_ID", "imagerow", "imagecol")`, and the row names must be the Spot_ID, which is the same as the row names in the cell type proportion data frame or the column names of the gene*spot expression data frame.}

\item{centerID}{A vector of length 1, representing a single Spot_ID that serves as the center for the neighborhood.}

\item{enhanced}{Logical; if `TRUE`, enhances the Seurat object by marking the neighborhood in a special way. Defaults to `FALSE`.}

\item{radius}{The radius of the spatial neighborhood, specified as a numeric value.}

\item{unitDist}{Numeric; the unit distance of the spatial transcriptomics based on its spatial coordinates.}
}
\value{
A list containing:
\describe{
  \item{centerID}{The input center Spot_ID.}
  \item{closeID}{The Spot_IDs of the neighboring spots within the specified radius.}
  \item{unit}{The unit distance used to determine the neighborhood.}
}
}
\description{
This function identifies the spatial neighborhood Spot IDs around a given center Spot ID within a specified radius.
}
