% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{Available_K}
\alias{Available_K}
\title{Available potassium (K) in soil}
\usage{
Available_K(W = W, VE = VE, VA = VA, VF = VF, FR = FR)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{VE}{Volume of extractant solution (mL)}

\item{VA}{Volume of aliquot of the extract (mL)}

\item{VF}{Volume of final solution fed to flame photometer (mL)}

\item{FR}{K concentration (mg/L) in final solution as obtained directly from the flame photometer or indirectly from the ‘Std_Curve’ function}
}
\value{
K_mgkg - Available K in soil (mg/kg)
K_kgha - Available K in soil (kg/ha)
K_cmolckg - Available K in soil (cmolc/kg)
K2O_mgkg - Available K in soil in terms of K2O (mg/kg)
K2O_kgha - Available K in soil in terms of K2O (kg/ha)
K2O_cmolckg - Available K in soil in terms of K2O (cmolc/kg)
}
\description{
The content of available K in soil as extracted by neutral normal ammonium acetate solution is obtained by this function based on flame photometric determination (Hanway and Heidel, 1952).
}
\details{
Available K is commonly extracted by 1 N ammonium acetate (pH 7), and determined by a flame photometer directly, or after dilution if needed (Hanway and Heidel, 1952). It includes solution K and exchangeable K present in soil, and is readily available to plants (Das et al., 2022). In case of no additional dilution after extraction, the values of VA and VF should be put as 1.
}
\examples{
with(data = df_Available_K, Available_K(W = Mass_Soil, VE = Vol_Extractant,
VA = Vol_Aliquot, VF = Vol_Final, FR =  Flame_Reading))

}
\references{
Hanway, J.J. and Heidel, H. (1952) Soil analysis methods as used in Iowa State College Soil Testing Laboratory. Iowa Agriculture 57, 1–13.

Das, D., Sahoo, J., Basit-Raza, Md., Barman, M. and Das, R. (2022) Ongoing soil potassium depletion under intensive cropping in India and probable mitigation strategies. A review. Agronomy for Sustainable Development 42:4. https://doi.org/10.1007/s13593-021-00728-6
}
