% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSrounding.R
\name{HD}
\alias{HD}
\alias{HDutility}
\title{Hellinger Distance (Utility)}
\usage{
HD(f, g)

HDutility(f, g)
}
\arguments{
\item{f}{Vector of original counts}

\item{g}{Vector of perturbed counts}
}
\value{
Hellinger distance or related utility measure
}
\description{
Hellinger distance (\code{HD}) and a related utility measure (\code{HDutility})
described in the reference below.
The utility measure is made to be bounded between 0 and 1.
}
\details{
HD is defined as "\code{sqrt(sum((sqrt(f) - sqrt(g))^2)/2)}" and
HDutility  is defined as "\code{1 - HD(f, g)/sqrt(sum(f))}".
}
\examples{
f <- 1:6
g <- c(0, 3, 3, 3, 6, 6)
print(c(
  HD = HD(f, g), 
  HDutility = HDutility(f, g), 
  maxdiff = max(abs(g - f)), 
  meanAbsDiff = mean(abs(g - f)), 
  rootMeanSquare = sqrt(mean((g - f)^2))
))
}
\references{
Shlomo, N., Antal, L., & Elliot, M. (2015).
Measuring Disclosure Risk and Data Utility for Flexible Table Generators,
Journal of Official Statistics, 31(2), 305-324. \doi{10.1515/jos-2015-0019}
}
