% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_plotSpider.R
\name{plotSpider}
\alias{plotSpider}
\title{Plot \code{Spider}}
\usage{
plotSpider(
  slick,
  byOM = FALSE,
  byMP = FALSE,
  OMs = NA,
  incMean = TRUE,
  incMax = TRUE,
  relScale = FALSE,
  col.om.title = "#D6501C",
  cex.om.title = 2,
  col.Mean = "white",
  bg.Mean = "black",
  grid.fill = "#f2f3f5",
  grid.line = "black",
  fill = byMP | all(byOM),
  inc.grid = TRUE,
  PI.labels = !(byMP | all(byOM)),
  MP_label = "Code",
  mp.lwd = 3,
  alpha = 0.3,
  ncol = 4,
  PI.mean.cex = 2.2,
  incMPtitle = byMP,
  mplab.cex = 2.2,
  max.pt.cex = 2,
  max.pt.col = "darkred"
)
}
\arguments{
\item{slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{byOM}{Logical Plot by OM? Otherwise mean over OMs}

\item{byMP}{Logical. Plot by MP? Otherwise all MPs together on one plot}

\item{OMs}{Integers representing the OMs to include in the plot. Defaults to all.}

\item{incMean}{Logical. Include mean PI score in center?}

\item{incMax}{Logical. Include colored points indicating maximum PI values?}

\item{relScale}{Logical. Scale PI values between minimum (0) and maximum (1)?}

\item{col.om.title}{Color of the OM names/labels}

\item{cex.om.title}{Size of OM names/labels}

\item{col.Mean}{Color of mean value text}

\item{bg.Mean}{Background color of mean value text}

\item{grid.fill}{Color of fill for the spider grid}

\item{grid.line}{Color of lines for the spider grid}

\item{fill}{Logical Fill the spider plot?}

\item{inc.grid}{Logical. Include the grid?}

\item{PI.labels}{Logical Show PI labels?}

\item{MP_label}{Label to use for the MPs. Either \code{Code} or \code{Label}.
\code{Description} works as well, but you probably don't want to do that.}

\item{mp.lwd}{Line width}

\item{alpha}{Alpha value for the fill}

\item{ncol}{Number of columns}

\item{PI.mean.cex}{Size of PI mean score text}

\item{incMPtitle}{Logical. Include MP label?}

\item{mplab.cex}{MP label size}

\item{max.pt.cex}{Max value point size}

\item{max.pt.col}{Max value point color}
}
\value{
A \code{ggplot2} object
}
\description{
A Spider or Radar plot
}
\examples{
# Generate dummy values
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nOM, nMP, nPI))

# Note: PI values must be between 0 and 1, with 1 indicating better performance
pi_means <- runif(nPI, 0, 1)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[om, mp, pi] <- runif(1, pi_means[pi])
    }
  }
}

# Create and populate Object
spider <- Spider(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)

# Check
Check(spider)

# Add to `Slick` object
slick <- Slick()
Spider(slick) <- spider

# Plots
plotSpider(slick)

plotSpider(slick, fill=TRUE)

plotSpider(slick, byMP=TRUE)

plotSpider(slick, byOM=TRUE)

}
