% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_MPs.R
\docType{class}
\name{MPs-class}
\alias{MPs-class}
\title{\code{MPs} S4 class and functions}
\description{
An object of class \code{MPs} contains information about the management procedures (MPs)
in a \code{\link[=Slick-class]{Slick-class()}} object. Like all S4 objects in \code{Slick}, slots in this
object can be accessed and assigned using functions corresponding to slot name.
See \code{\link[=MPs]{MPs()}} and the the \verb{See Also} section below.
}
\details{
Objects of class \code{MPs} are created with \code{MPs()}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of management procedures (\code{nMPs}) in the plot objects \code{Boxplot},
\code{Kobe}, \code{Quilt}, \code{Spider}, \code{Timeseries}, and \code{Tradeoff}.
}
}
\section{Slots}{

\describe{
\item{\code{Code}}{A \emph{short} code for the Management Procedures in this \code{Slick} object.
A character string length \code{nMP} or a named list for multi-language support. See \code{Details}
\emph{Required}}

\item{\code{Label}}{A short label for the  Management Procedures in this \code{Slick} object.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nMP} or a named list for multi-language support. See \code{Details}
\emph{Required}}

\item{\code{Description}}{A description for the Management Procedures in this \code{Slick} object.
Can include Markdown, see \code{Examples}.
A character string length \code{nMP} or a named list for multi-language support. See \code{Details}}

\item{\code{Color}}{A character vector of colors for the MPs. Defaults will be used if not populated}

\item{\code{Preset}}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}
}}

\examples{

myMPs <- MPs()
Code(myMPs) <- c('MP1', 'MP2', 'MP3')
Label(myMPs) <- c('Management Procedure 1',
                  'Management Procedure 2',
                  'Management Procedure 3')
Description(myMPs) <- c('This is the description for Management Procedure 1',
                        'This is the description for Management Procedure 2',
                        'This is the description for Management Procedure 3')

Preset(myMPs) <- list(All=1:3, FirstTwo=1:2)


myMPs

# Multi-language
Description(myMPs) <- list(en=c('This is the English description for Management Procedure 1',
                             'This is the English description for Management Procedure 2',
                             'This is the English description for Management Procedure 3'),
                           es=c("This is the Spanish description for Management Procedure 1",
                             "This is the Spanish description for Management Procedure 2",
                             "This is the Spanish description for Management Procedure 3"),
                           fr=c("This is the French description for Management Procedure 1",
                             "This is the French description for Management Procedure 2",
                             "This is the French description for Management Procedure 3"),
                           pt=c("This is the Portuguese description for Management Procedure 1",
                                "This is the Portuguese description for Management Procedure 2",
                                "This is the Portuguese description for Management Procedure 3")
                           )

Metadata(myMPs)
Metadata(myMPs, 'es')
Metadata(myMPs, 'fr')
Metadata(myMPs, 'pt')
}
\seealso{
\code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Preset]{Preset()}}
}
