% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractSimplicialComplex.R
\name{abstract_simplicial_complex}
\alias{abstract_simplicial_complex}
\title{Compute Euler characteristic for an abstract simplicial complex}
\usage{
abstract_simplicial_complex(simplices, dimension, tol = NULL)
}
\arguments{
\item{simplices}{A list of simplices (each a numeric vector).}

\item{dimension}{Optional max dimension to compute up to.}

\item{tol}{Optional numerical tolerance to pass to \code{rankMatrix()}.}
}
\value{
The Euler characteristic \eqn{\chi}.
}
\description{
Compute Euler characteristic for an abstract simplicial complex
}
\examples{
simplices <- list(c(1, 2), c(3, 4), c(2, 1, 3), c(4, 2))
abstract_simplicial_complex(simplices, 2)
}
