% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTimeVar.R
\name{override_tbin_probs}
\alias{override_tbin_probs}
\title{Override probabilities for time-varying binary variables}
\usage{
override_tbin_probs(mus0, n.TBins, n.OtherBins, zero = 1e-04)
}
\arguments{
\item{mus0}{The matrix of cluster means.}

\item{n.TBins}{Number of time-varying binary variables.}

\item{n.OtherBins}{The number of static binary variables.}

\item{zero}{A number very close to 0, but slightly larger.}
}
\description{
An internal function not intended for the user. For clusters assigned to have a given time-varying binary variable
always equal to 0,
overrides to 0 the corresponding proportion of observations with the binary variable equal to 1.
}
\examples{
# make example subject means matrix for 1 static binary, 
#  1 time-varying binary, and 1 normal
#  50 subjects and 5 observations (latter plays into variance)
set.seed(451)
mus0 = mod.jointly.generate.binary.normal( no.rows = 50, no.bin = 2, no.nor = 2,
                                           prop.vec.bin = c( .5, .35 ),
                                           mean.vec.nor = c( .4, 100 ),
                                           var.nor = c( (0.4 * 0.6) / 5, 10 ),
                                           corr.vec = c(0.05, .08, 0, 0, -0.03, 0) )

# note that we have ever-users with non-zero propensities to be on drug: not okay
any( mus0[,1] == 0 & mus0[,3] != 0 )

# fix them
mus1 = override_tbin_probs( mus0, 1, 1 )

# all better!
any( mus1[,1] == 0 & mus1[,3] > 0.0001 )
}
