% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTimeVar.R
\name{complete_parameters}
\alias{complete_parameters}
\title{Fill in partially incomplete parameters matrix}
\usage{
complete_parameters(parameters, n)
}
\arguments{
\item{parameters}{Initial parameters matrix that may contain \code{NA} values.}

\item{n}{The number of clusters}
}
\description{
Fills in "strategic" \code{NA} values in a user-provided parameters matrix by (1) calculating
SDs for proportions using the binomial distribution; (2) calculating variances based on SDs; and (3)
setting within-cluster variances to 1/3 of the across-cluster variances (if not already specified).
}
\details{
For binary variables, uses binomial distribution to compute across-cluster standard deviation of proportion. Where there 
are missing values, fills in variances given standard deviations and vice-versa. Where there are missing values in 
\code{within.var}, fills these in by defaulting to 1/3 of the corresponding across-cluster variance.
}
\examples{
complete_parameters(params, n=10)
}
