% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{posterior_prediction}
\alias{posterior_prediction}
\title{Predicted probability of \code{y} given \code{x} conditional on association and given data.}
\usage{
posterior_prediction(
  ontology,
  x,
  y,
  sim_reg_out,
  x_new = x,
  information_content = get_term_info_content(ontology, x),
  sim_params = list(ontology = ontology, information_content = information_content),
  two_way = TRUE,
  prediction_fn = NULL,
  min_ratio = 0.001,
  ...
)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{x}{\code{list} of \code{character} vectors of ontological terms.}

\item{y}{\code{logical} response vector.}

\item{sim_reg_out}{Object of class \code{sim_reg_output}.}

\item{x_new}{New \code{list} of ontological term sets to perform prediction on. Defaults to \code{x}.}

\item{information_content}{Numeric vector of information contents of terms named by term ID. Defaults to information content based on frequencies of annotation in \code{x}.}

\item{sim_params}{List of arguments to pass to \code{get_asym_sim_grid}.}

\item{two_way}{Boolean value determining whether to calculate semantic similarity `in both directions' (i.e. compute \code{s_x} and \code{s_phi} or just \code{s_phi}).}

\item{prediction_fn}{Function for computing predicted probabilities for \code{y[i]=TRUE}.}

\item{min_ratio}{Threshold for fraction of posterior probability which sampled phi must hold in order to be included in sum.}

\item{...}{Additional arguments to pass to \code{prediction_fn}.}
}
\value{
Vector of predicted probabilities corresponding to term sets in \code{x_new}.
}
\description{
Predicted probability of \code{y} given \code{x} conditional on association and given data.
}
