% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_levels.R
\name{set_levels}
\alias{set_levels}
\title{Set simulation levels}
\usage{
set_levels(sim, ..., .keep = NA)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{...}{One or more key-value pairs representing simulation levels. Each
value can either be a vector (for simple levels) or a list of lists (for
more complex levels). See examples.}

\item{.keep}{An integer vector of level_id values specifying which level
combinations to keep; see the Advanced Functionality documentation.}
}
\value{
The original simulation object with the old set of levels replaced
    with the new set
}
\description{
Set one or more simulation levels, which are things that vary
    between simulation replicates.
}
\examples{
# Basic simulation levels are numeric or character vectors
sim <- new_sim()
sim \%<>\% set_levels(
  n = c(10, 100, 1000),
  est = c("M", "V")
)

# Complex simulation levels can be set using named lists of lists
sim <- new_sim()
sim \%<>\% set_levels(
  n = c(10, 100, 1000),
  distribution = list(
    "Beta 1" = list(type="Beta", params=c(0.3, 0.7)),
    "Beta 2" = list(type="Beta", params=c(1.5, 0.4)),
    "Normal" = list(type="Normal", params=c(3.0, 0.2))
  )
)
}
