% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_thres.R
\name{quantile_thres}
\alias{quantile_thres}
\title{quantile_thres}
\usage{
quantile_thres(so)
}
\arguments{
\item{so}{a SiFINeT object}
}
\value{
SiFINeT object with data.thres (categorized count matrix) updated.
}
\description{
The function classifies count data into binary low (0) - high (1) data, based on whether the count number is greater than a threshold.
}
\details{
The threshold used for classification is defined by quantile regression on each gene using Frisch–Newton interior point method ("fn" option for method variable in quantreg package, rq function).
By default if no meta data is provided, the quantile regression would be applied on the mean expression level of each cell.
The quantile to be estimated in the quantile regression is set to be the estimated 50\% quantile of the non-zero part of the expression level for each gene.
If the expression level of a gene is low (with median 0), then the threshold is set to be 0.
}
\references{
Koenker, R. and S. Portnoy (1997) The Gaussian Hare and the Laplacean Tortoise: Computability of Squared-error vs Absolute Error Estimators, (with discussion). Statistical Science, 12, 279-300.

Roger Koenker (2022). quantreg: Quantile Regression. R package version 5.94. https://CRAN.R-project.org/package=quantreg
}
