% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCumulative.R
\name{plotCumulative}
\alias{plotCumulative}
\title{Plot cumulative and category probabilities of cumulative logit model}
\usage{
plotCumulative(x, type = "cumulative", matching.name = "matching")
}
\arguments{
\item{x}{object of class \code{vglm}}

\item{type}{character: type of plot to be displayed. Options are
\code{"cumulative"} (default) for cumulative probabilities and
\code{"category"} for category probabilities.}

\item{matching.name}{character: name of matching criterion used for
estimation in \code{x}.}
}
\value{
An object of class \code{ggplot} and/or \code{gg}.
}
\description{
Function for plotting cumulative and category probabilities
function estimated by \code{vglm()} function from the \code{VGAM} package
using the \pkg{ggplot2} package.
}
\examples{
# loading packages
library(VGAM)

# loading data
data(Science, package = "mirt")

# total score calculation
score <- rowSums(Science)
Science[, 1] <- factor(Science[, 1], levels = sort(unique(Science[, 1])), ordered = TRUE)

# cumulative logit model for item 1
fit <- vglm(Science[, 1] ~ score, family = cumulative(reverse = TRUE, parallel = TRUE))
# coefficients for item 1
coef(fit)

plotCumulative(fit, type = "cumulative", matching.name = "Total score")
plotCumulative(fit, type = "category", matching.name = "Total score")

}
\seealso{
\code{\link[VGAM:vglm]{VGAM::vglm()}}
}
\author{
Tomas Jurica \cr Institute of Computer Science of the Czech Academy
of Sciences \cr

Adela Hladka \cr Institute of Computer Science of the Czech Academy of
Sciences \cr \email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr Institute of Computer Science of the Czech Academy of
Sciences \cr \email{martinkova@cs.cas.cz} \cr
}
