% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demography_functions.R
\name{Simulate_harvest_slots}
\alias{Simulate_harvest_slots}
\title{Simulate_harvest_slots}
\usage{
Simulate_harvest_slots(
  n,
  data,
  M.estimators = NULL,
  Age.mid.point = NULL,
  HS.width = NULL,
  max.F = 1
)
}
\arguments{
\item{n}{number of iterations for each combination of Age.mid.point, HS.width and F.}

\item{data}{A multi-level list of the class `Demography.inputs` produced from the
`create_data_input` function and then manually completed.}

\item{M.estimators}{Any specific natural mortality estimators to be included in the analysis.
Only one will be used in each run which is randomly selected. Must be a single estimator
or a vector of estimators. These can include: "Pet.Wro","Jensen.mat","Chen.Yuan",
"Then_hoenig","Then_pauly", "Jensen.mat","Charnov" or "Chen.Want". If none are specified
then all applicable estimators could be chosen.}

\item{Age.mid.point}{A vector of ages to be used in the simulation. Each age is used as
a mid point and will have HS.Width subtracted and added to it to determine AAFC and AALC,
respectively.}

\item{HS.width}{A vector of widths for the Harvest slots in years. Widths are subtracted and added to mid points to determine
the AAFC and AALC in each sim.}

\item{max.F}{The maximum value of F for simulations}
}
\value{
A data.frame with three columns: MinAge, MaxAge and 'F.'. These represent the age at the
    start of a harvest slot, the age at the end of the harvest slot and the F for that harvest slot.
}
\description{
This is a wrapper function for `Calculate_demography` which runs this function
    using different values of AAFC, AALC and F to simulate Havest Slot options. The Fcritical is retuned
    for each simulation to show the max level of F needed to sustain a stable population.
}
\examples{
\donttest{
# load Silky shark data produced by create_data_input()
# Type `?create_data_input()` for details
data("Silky_data")

# Run function to get conduct an F critical analysis for different harvest slots using
# Monte Carlo Simulations using for all available natural mortality estimators.
# Set n = at least 1000 for full analysis but use n = 10 for testing given long run times

Simulate_harvest_slots(n = 10, Silky_data,Age.mid.point = 0:28, HS.width = 0:8)
}
}
