% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_terminal_observations.R
\name{add_terminal_observations}
\alias{add_terminal_observations}
\title{Add Terminal Observations to a Dataset}
\usage{
add_terminal_observations(
  data,
  id,
  time,
  end = max(pull(data, {
     {
         time
     }
 }))
)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{id}{A variable in \code{data} that identifies the subject.}

\item{time}{A variable in \code{data} that identifies the time of the observation.}

\item{end}{The value to use for the \code{time} variable in the terminal observation.
If end is less that the maximum in the dataset resulting data will
be filtered such that \code{time} is less than or equal to \code{end}.}
}
\value{
A data frame with terminal observations added.
}
\description{
This function adds terminal observations to a dataset.
For each subject given by \code{id}, if that subject has less than the maximum
number of observations, A row is added with the \code{end} time value, leaving all
other variables as \code{NA}.
}
\examples{
exdata <- tibble::tibble(
  patient = rep(1:3, 3:5),
  day = c(0, 30, 60,
          0, 30, 60, 90,
          0, 30, 60, 90, 120),
  value = TRUE
)
add_terminal_observations(exdata, patient, day)
}
\seealso{
\code{\link[tidyr:complete]{tidyr::complete()}}
}
