% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_setMUSICOption}
\alias{seasonder_setMUSICOption}
\title{Set a Specific MUSIC Option for a SeaSondeRCS Object}
\usage{
seasonder_setMUSICOption(seasonder_cs_object, option_name, option_value)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object that contains the MUSIC data as an attribute.}

\item{option_name}{A character string specifying the name of the MUSIC option to update.}

\item{option_value}{The new value to assign to the specified MUSIC option.}
}
\value{
The updated SeaSondeRCS object with the specified MUSIC option modified.
}
\description{
This function updates a single MUSIC option in the MUSIC data of a SeaSondeRCS object.
It verifies that the provided option name is valid (i.e. exists in the default options),
then updates that field with the new value.
}
\details{
The function first checks if \code{option_name} is one of the valid options as provided by
\code{seasonder_defaultMUSICOptions()}. If not, it calls \code{seasonder_logAndAbort} to log an error.
Then, the current MUSIC options are retrieved, updated with the new value, and stored back into the object.
}
\examples{
# Example: set a specific MUSIC option on a minimal CS object
header <- list(nRangeCells = 1, nDopplerCells = 1)
data <- list(
  SSA1 = matrix(0,1,1), SSA2 = matrix(0,1,1), SSA3 = matrix(0,1,1),
  CS12 = matrix(complex(real=0,imaginary=0),1,1),
  CS13 = matrix(complex(real=0,imaginary=0),1,1),
  CS23 = matrix(complex(real=0,imaginary=0),1,1), QC = matrix(0,1,1)
)
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(list(header = header, data = data), 
seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setMUSICOption(cs_obj, "smoothNoiseLevel", TRUE)
opts <- seasonder_getMUSICOptions(cs_obj)
print(opts$smoothNoiseLevel)
}
