% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getSeaSondeRCS_MUSIC_CenterDopplerBin}
\alias{seasonder_getSeaSondeRCS_MUSIC_CenterDopplerBin}
\title{Retrieve the Center Doppler Bin for MUSIC Analysis}
\usage{
seasonder_getSeaSondeRCS_MUSIC_CenterDopplerBin(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing data and parameters
for MUSIC analysis.}
}
\value{
An integer representing the center Doppler bin.
}
\description{
This function calculates the center Doppler bin for a \code{SeaSondeRCS} object.
The center bin corresponds to the Doppler bin representing zero frequency,
and the computation accounts for adjustments from the MUSIC Doppler interpolation.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the total number of Doppler cells, including adjustments for MUSIC
interpolation, using \code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}}.
\item Computes the center Doppler bin using \code{\link{seasonder_computeCenterDopplerBin}},
which determines the bin corresponding to zero frequency.
}

The center Doppler bin is a key parameter for organizing Doppler frequency data
around zero and is critical for spectral analysis.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}} to retrieve the adjusted number of Doppler cells.
\code{\link{seasonder_computeCenterDopplerBin}} for the center bin calculation.
}
