% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_SeaSondeRCS_plotSelfSpectrum}
\alias{seasonder_SeaSondeRCS_plotSelfSpectrum}
\title{Plot Self-Spectrum for a SeaSondeRCS Object}
\usage{
seasonder_SeaSondeRCS_plotSelfSpectrum(
  seasonder_cs_object,
  antenna,
  range_cell,
  doppler_units = "normalized doppler frequency",
  plot_FORs = FALSE
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing spectral and metadata.}

\item{antenna}{An integer or vector specifying the antenna(s) to extract the self-spectrum from.}

\item{range_cell}{An integer indicating the range cell to extract the spectrum.}

\item{doppler_units}{A character string specifying the desired Doppler units for the plot.
Commonly "normalized doppler frequency" or "doppler frequency" (Hz). Default is "normalized doppler frequency".}

\item{plot_FORs}{Logical. If \code{TRUE}, the function overlays elements related to the first order region (FOR)
such as vertical lines at the FOR boundaries and the smoothed self-spectrum. Default is \code{FALSE}.}
}
\value{
A ggplot object representing the self-spectrum plot.
}
\description{
This function generates a plot of the self-spectrum (in dB) for a specified antenna and range cell
from a SeaSondeRCS object. The Doppler frequencies are converted to the desired units before plotting.
Optionally, it overlays additional elements such as smoothed self-spectrum lines, first-order region (FOR)
vertical lines, and noise level lines.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the self-spectrum data for the given antenna and range cell using \code{seasonder_getSeaSondeRCS_SelfSpectra}.
\item Converts the Doppler bin frequencies to the specified units using \code{seasonder_SwapDopplerUnits}.
\item Converts the self-spectrum to dB using \code{seasonder_SelfSpectra2dB} and combines it with the Doppler values.
\item Retrieves the Bragg Doppler angular frequency for plotting a reference vertical line.
\item If \code{plot_FORs} is \code{TRUE}, overlays:
\itemize{
\item An orange line for the smoothed self-spectrum.
\item Blue vertical lines for FOR boundaries.
\item Red lines indicating the noise level across the Doppler spectrum.
}
\item Finally, returns the ggplot object.
}
}
\examples{
# Prepare a SeaSondeRCS object for plotting self-spectrum
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
# Plot self-spectrum for antenna 1, range cell 5
p <- seasonder_SeaSondeRCS_plotSelfSpectrum(cs_obj, antenna = 1, range_cell = 5)
print(p)

}
