% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILOCorrectSite.R
\name{SILOCorrectSite}
\alias{SILOCorrectSite}
\title{Correct a slope change in a rainfall data set based on another site}
\usage{
SILOCorrectSite(
  X,
  s_correct,
  s_reference,
  year_break,
  year_start = NULL,
  year_end = NULL,
  after = TRUE,
  plot = NA
)
}
\arguments{
\item{X}{A list of SILO station data, in the format created by \code{\link[SWTools]{SILOLoad}}}

\item{s_correct}{Station number that exists in \code{X} to correct}

\item{s_reference}{Station number that exists in \code{X} to used for the correction}

\item{year_break}{year in the time series that the break points exists}

\item{year_start}{first year of data (before \code{year_break}) to to develop the first linear regression between \code{s_correct} and \code{s_reference}. Defaults to the start of the dataset}

\item{year_end}{last year of data (after \code{year_break}) to to develop the second linear regression between \code{s_correct} and \code{s_reference}. Defaults to the end of the dataset}

\item{after}{TRUE/FALSE value, indicating if the homogeneous data to develop the relationship to correct the non-homogeneous data is after the breakpoint (\code{TRUE}) or before (\code{FALSE}).}

\item{plot}{if specified, the file (including path if necessary) to save a scatter plot of the annual rainfall totals, including regression equations used to correct the non-homogeneous data.}
}
\value{
A list with the same structure as \code{X}, with the element for \code{s_correct} updated with the corrections on one side of the breakpoint year.
}
\description{
If the break point of a non-homogenous rainfall station has been identified (potentially using \link[SWTools]{SILOCheckConsistency}), correct the data on one side of the breakpoint
}
\details{
The method of cumulative residuals outlined in \href{https://www.fao.org/4/x0490e/x0490e0l.htm#annex\%204.\%20statistical\%20analysis\%20of\%20weather\%20data\%20sets\%201}{Annex 4} of Allen et al. (1998) has been used.
That is, two linear regressions between the annual rainfall totals are calculated \code{P_s_correct~P_s_reference} over the periods year_start:year_break and year_break:year_end
For the period to correct (after the breakpoint if \code{after=TRUE}) an annual scaling factor is calculated from the ratio of the predicted rainfall total from the two regression equations, based on the rainfall total for each year at the reference site.
This scaling factor is then applied to the daily rainfall data for that year.
}
\examples{
\dontrun{
stations<-c("23313","23302","23300","23317","23725","23705")
SILODownload(stations)
X<-SILOLoad(stations,startdate="1891-01-01",enddate="2020-12-31")
X<-SILOCorrectSite(X,"23313","23705",1970,after=FALSE)
}

}
\references{
Chang, M., and Lee, R. (1974) Objective double-mass analysis, Water Resour. Res., 10( 6), 1123– 1126, doi:10.1029/WR010i006p01123.
}
\seealso{
\link[SWTools]{SILOLoad}, \link[SWTools]{SILOSiteSummary}, \link[SWTools]{SILOQualityCodes},\link[SWTools]{SILOCorrectSite}
}
