% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{rename}
\alias{rename}
\title{Rename Stressed Models}
\usage{
rename(object, names, k = 1)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object}

\item{names}{Character vector, the new names of k-th stressed model.}

\item{k}{Numeric vector, the k-th stressed model of object to rename. (\code{default = 1}).}
}
\value{
An renamed object of class \code{SWIM} containing:
  \itemize{
    \item \code{x}, a data.frame containing the data;
    \item \code{new_weights}, a list, each component corresponds to 
   a different stress and is either a vector of scenario weights or a
   function, that applied to a column of \code{x}, generates the 
   vectors of scenario weights; 
    \item \code{type}, a list, each component corresponds to a 
   different stress and specifies the type of the stress;
    \item \code{specs}, a list, each component corresponds to 
   a different stress and contains a list with the specifications 
   of what has been stressed.
  }
See \code{\link{SWIM}} for details.
}
\description{
Rename Stressed Models
}
\details{
Get a new \code{SWIM} object with desired \code{name}
}
\examples{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000),
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x,
  alpha = 0.9, q_ratio = 1.05)
res1 <- rename(res1, "VaR_09", 1)

}
\author{
Kent Wu
}
