% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputed_mtcars.R
\docType{data}
\name{imputed_mtcars}
\alias{imputed_mtcars}
\title{Imputed mtcars Dataset}
\format{
A data frame with 160 rows and 13 variables
}
\source{
Original dataset from \code{datasets::mtcars}, with missing values introduced and imputed.
}
\usage{
imputed_mtcars
}
\description{
This dataset is a version of the \code{mtcars} dataset where random missing values
were introduced, and multiple imputation was performed using the \code{mice} package.
}
\details{
Random missingness was introduced into 10\% of the values in the original \code{mtcars} dataset.
Multiple imputation was then performed using the \code{mice} package with the following parameters:
\itemize{
\item 5 multiple imputations (\code{m = 5}).
\item 50 iterations per imputation (\code{maxit = 50}).
\item Seed set to 123 for reproducibility.
}
The dataset included here is the first completed dataset resulting from the multiple imputation process.
}
\examples{
\donttest{
data(imputed_mtcars)
head(imputed_mtcars)
}
}
\keyword{datasets}
