% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{ssn_params}
\alias{ssn_params}
\alias{tailup_params}
\alias{taildown_params}
\alias{euclid_params}
\alias{nugget_params}
\title{Create covariance parameter objects.}
\usage{
tailup_params(tailup_type, de, range)

taildown_params(taildown_type, de, range)

euclid_params(euclid_type, de, range, rotate, scale)

nugget_params(nugget_type, nugget)
}
\arguments{
\item{tailup_type}{The tailup covariance function type. Available options
include \code{"linear"}, \code{"spherical"}, \code{"exponential"},
\code{"mariah"}, \code{"epa"}, and \code{"none"}.}

\item{de}{The spatially dependent (correlated) random error variance. Commonly referred to as
a partial sill.}

\item{range}{The correlation parameter.}

\item{taildown_type}{The taildown covariance function type. Available options
include \code{"linear"}, \code{"spherical"}, \code{"exponential"},
\code{"mariah"}, \code{"epa"}, and \code{"none"}.}

\item{euclid_type}{The euclidean covariance function type. Available options
include \code{"spherical"}, \code{"exponential"}, \code{"gaussian"},
\code{"cosine"}, \code{"cubic"}, \code{"pentaspherical"}, \code{"wave"},
\code{"jbessel"}, \code{"gravity"}, \code{"rquad"}, \code{"magnetic"}, and
\code{"none"}.}

\item{rotate}{Anisotropy rotation parameter (from 0 to \eqn{\pi} radians) for
the euclidean portion of the covariance. A value of 0 (the default) implies no rotation.}

\item{scale}{Anisotropy scale parameter (from 0 to 1) for
the euclidean portion of the covariance. A value of 1 (the default) implies no scaling.}

\item{nugget_type}{The nugget covariance function type. Available options
include \code{"nugget"} or \code{"none"}.}

\item{nugget}{The spatially independent (not correlated) random error variance. Commonly referred to as
a nugget.}
}
\value{
A parameter object with class that matches the relevant \code{type} argument.
}
\description{
Create a covariance parameter object for us with other functions.
See \code{\link[spmodel:randcov_params]{spmodel::randcov_params()}} for documentation regarding
random effect covariance parameter objects.
}
\examples{
tailup_params("exponential", de = 1, range = 20)
taildown_params("exponential", de = 1, range = 20)
euclid_params("exponential", de = 1, range = 20, rotate = 0, scale = 1)
nugget_params("nugget", nugget = 1)
}
\references{
Peterson, E.E. and Ver Hoef, J.M. (2010) A mixed-model moving-average approach
to geostatistical modeling in stream networks. \emph{Ecology} \bold{91(3)},
644--651.

Ver Hoef, J.M. and Peterson, E.E. (2010) A moving average approach for spatial
statistical models of stream networks (with discussion).
\emph{Journal of the American Statistical Association} \bold{105}, 6--18.
DOI: 10.1198/jasa.2009.ap08248.  Rejoinder pgs. 22--24.
}
