% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{construct.P.1d}
\alias{construct.P.1d}
\title{Construct the change of basis matrix from univariate monomials to Legendre
polynomials.}
\usage{
construct.P.1d(basis)
}
\arguments{
\item{basis}{A matrix. Rows are taken as the degree of the associated
monomial.}
}
\value{
A matrix which functions as a change of basis from monomials to
  Legendre.
}
\description{
Let \eqn{f(x)} be the vector of monomials implied by the matrix \code{basis}.
Let \eqn{P} be the matrix generated by \code{Legendre_P_1d}.  Then
\eqn{g(x)=P^Tf(x)} is the vector of Legendre polynomials with leading terms
corresponding to \code{basis}. \emph{e.g.} the matrix \eqn{(0 1 2)^T} implies
\eqn{f(x)^T = (1 x x^2)}. Then \eqn{g(x)^T = (L_0, L_1, L_2)}.
}
\keyword{internal}

