% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_d2.R
\name{compute_d2}
\alias{compute_d2}
\title{Squared Discriminant Score for Two-Group LDA (Equal Covariance)}
\usage{
compute_d2(y, mu1, mu2, Sigma_inv, pi1, pi2)
}
\arguments{
\item{y}{Numeric vector (length \eqn{p}) or numeric matrix with \eqn{p} columns;
rows are observations.}

\item{mu1, mu2}{Numeric vectors of length \eqn{p}: class means.}

\item{Sigma_inv}{\eqn{p \times p} numeric precision matrix (inverse covariance).}

\item{pi1, pi2}{Positive scalars: class prior probabilities (need not sum to 1).}
}
\value{
If \code{y} is a vector, a single numeric \eqn{d^2}. If \code{y} is a matrix,
a numeric vector of \eqn{d^2} values for each row.
}
\description{
Computes \eqn{d^2} where \eqn{d = \beta_0 + y^\top \beta_1} for two classes
under the common-covariance (LDA) model:
\deqn{\beta_1 = \Sigma^{-1}(\mu_1 - \mu_2), \quad
      \beta_0 = \log(\pi_1/\pi_2) - \tfrac{1}{2}(\mu_1 + \mu_2)^\top \Sigma^{-1}(\mu_1 - \mu_2).}
}
\examples{
set.seed(1)
mu1 <- c(0, 0); mu2 <- c(1, 1)
S <- matrix(c(1, .2, .2, 1), 2, 2)
Sigma_inv <- solve(S)
x <- c(0.5, -0.2)
compute_d2(x, mu1, mu2, Sigma_inv, pi1 = 0.6, pi2 = 0.4)

X <- matrix(rnorm(10 * 2), ncol = 2)
compute_d2(X, mu1, mu2, Sigma_inv, 0.5, 0.5)

}
