% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesclassifier.R
\name{bayesclassifier}
\alias{bayesclassifier}
\title{Bayes' Rule Classifier}
\usage{
bayesclassifier(dat, p, g, pi = NULL, mu = NULL, sigma = NULL, paralist = NULL)
}
\arguments{
\item{dat}{An \eqn{n \times p} numeric matrix (or a length-\eqn{p} numeric vector,
treated as \eqn{1 \times p}).}

\item{p}{Integer; dimension of the observation vector.}

\item{g}{Integer; number of Gaussian components/classes.}

\item{pi}{Numeric length-\eqn{g} vector of mixing proportions (must sum to 1).}

\item{mu}{Either:
\itemize{
\item A \eqn{p \times g} numeric matrix (column \eqn{i} is \eqn{\mu_i}), or
\item A length-\eqn{g} list of length-\eqn{p} numeric vectors.
}}

\item{sigma}{Either:
\itemize{
\item A \eqn{p \times p} covariance matrix (shared), or
\item A length-\eqn{g} list of \eqn{p \times p} covariance matrices, or
\item A \eqn{p \times p \times g} numeric array.
}}

\item{paralist}{Optional list with elements \code{pi}, \code{mu}, \code{sigma}
(overrides explicit args if provided and non-\code{NULL}).}
}
\value{
An integer vector of length \eqn{n} with predicted class labels in \eqn{1:g}.
}
\description{
Classifier specified by Bayes' rule.
Assigns \eqn{\arg\max_i \{ \log(\pi_i) + \log \mathcal{N} (y_j \mid \mu_i, \Sigma_i) \}}.
}
\examples{
# Minimal example with list-style mu and sigma:
set.seed(1)
p <- 2; g <- 2
pi <- c(0.5, 0.5)
mu <- list(`1`=c(0.96, 0.02), `2`=c(-1.02, -0.03))
sigma <- list(
  matrix(c(0.9417379,0.5447264, 0.5447264,0.9811853), 2, 2, byrow=TRUE),
  matrix(c(0.9984812,0.3314474, 0.3314474,1.1316865), 2, 2, byrow=TRUE)
)
X <- mvtnorm::rmvnorm(5, mean = mu[[1]], sigma = sigma[[1]])
bayesclassifier(X, p=p, g=g, pi=pi, mu=mu, sigma=sigma)

}
