% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stacking.R
\name{stacking}
\alias{stacking}
\alias{stacking,Ensemble.SDM-method}
\title{Stack different ensemble SDMs in an SSDM}
\usage{
stacking(
  esdm,
  ...,
  name = NULL,
  method = "pSSDM",
  rep.B = 1000,
  Env = NULL,
  range = NULL,
  endemism = c("WEI", "Binary"),
  eval = TRUE,
  uncertainty = TRUE,
  verbose = TRUE,
  GUI = FALSE
)

\S4method{stacking}{Ensemble.SDM}(
  esdm,
  ...,
  name = NULL,
  method = "pSSDM",
  rep.B = 1000,
  Env = NULL,
  range = NULL,
  endemism = c("WEI", "Binary"),
  eval = TRUE,
  uncertainty = TRUE,
  verbose = TRUE,
  GUI = FALSE
)
}
\arguments{
\item{esdm, ...}{character. Ensemble SDMs to be stacked.}

\item{name}{character. Optional name given to the final SSDM produced (by
default 'Species.SDM').}

\item{method}{character. Define the method used to create the local species
richness map (see details below).}

\item{rep.B}{integer. If the method used to create the local species richness
is the random bernoulli (\strong{Bernoulli}), rep.B parameter defines the number of
repetitions used to create binary maps for each species.}

\item{Env}{raster object. Stacked raster object of environmental variables
(can be processed first by \code{\link{load_var}}). Needed only for stacking
method using probability ranking from richness (\strong{PRR}).}

\item{range}{integer. Set a value of range restriction (in pixels) around
presences occurrences on habitat suitability maps (all further points will
have a null probability, see Crisp et al (2011) in references). If NULL, no
range restriction will be applied.}

\item{endemism}{character. Define the method used to create an endemism map
(see details below).}

\item{eval}{logical. If set to FALSE, disable stack evaluation.}

\item{uncertainty}{logical. If set to TRUE, generates an uncertainty map and
an algorithm correlation matrix.}

\item{verbose}{logical. If set to TRUE, allows the function to print text in
the console.}

\item{GUI}{logical. Don't take that argument into account (parameter for the
user interface).}
}
\value{
an S4 \linkS4class{Stacked.SDM} class object viewable with the
 \code{\link{plot.model}} function.
}
\description{
This is a function to stack several ensemble SDMs in an SSDM. The function
takes as inputs several S4 \linkS4class{Ensemble.SDM} class objects produced
with \code{\link{ensemble_modelling}} or \code{\link{ensemble}} functions. The
function returns an S4 \linkS4class{Stacked.SDM} class object containing the
local species richness map, the between-algorithm variance map, and all
evaluation tables coming with (model evaluation, algorithm evaluation,
algorithm correlation matrix and variable importance), and a list of ensemble
SDMs for each species (see \code{\link{ensemble_modelling}}).
}
\details{
\strong{Methods:} Choice of the method used to compute the local
 species richness map (see Calabrese et al. (2014) and D'Amen et al (2015) for
 more informations, see reference below): \describe{\item{pSSDM}{sum
 probabilities of habitat suitability maps}\item{Bernoulli}{draw repeatedly
 from a Bernoulli distribution}\item{bSSDM}{sum the binary map obtained with
 the thresholding (depending on the metric of the
 ESDM).}\item{MaximumLikelihood}{adjust species richness of the model by
 linear regression}\item{PRR.MEM}{model richness with a macroecological model
 (MEM) and adjust each ESDM binary map by ranking habitat suitability and
 keeping as much as predicted richness of the MEM}\item{PRR.pSSDM}{model
 richness with a pSSDM and adjust each ESDM binary map by ranking habitat
 suitability and keeping as much as predicted richness of the pSSDM}}

 \strong{Endemism:} Choice of the method used to compute the endemism map
 (see Crisp et al. (2001) for more information, see reference below):
 \describe{\item{NULL}{No endemism map}\item{WEI}{(Weighted Endemism Index)
 Endemism map built by counting all species in each cell and weighting each
 by the inverse of its range} \item{CWEI}{(Corrected Weighted Endemism Index)
 Endemism map built by dividing the weighted endemism index by the total
 count of species in the cell.}}First string of the character is the method
 either WEI or CWEI, and in those cases second string of the vector is used
 to precise range calculation, whether the total number of occurrences
 \strong{'NbOcc'} whether the surface of the binary map species distribution
 \strong{'Binary'}.
}
\examples{
\dontrun{
# Loading data
data(Env)
data(Occurrences)
Occ1 <- subset(Occurrences, Occurrences$SPECIES == 'elliptica')
Occ2 <- subset(Occurrences, Occurrences$SPECIES == 'gracilis')

# SSDM building
ESDM1 <- ensemble_modelling(c('CTA', 'SVM'), Occ1, Env, rep = 1,
                           Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
                           name = 'elliptica', ensemble.thresh = c(0.6))
ESDM2 <- ensemble_modelling(c('CTA', 'SVM'), Occ2, Env, rep = 1,
                           Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
                           name = 'gracilis', ensemble.thresh = c(0.6))
SSDM <- stacking(ESDM1, ESDM2)

# Results plotting
plot(SSDM)
}

}
\references{
M. D'Amen, A. Dubuis, R. F. Fernandes, J. Pottier, L. Pelissier, &
 A Guisan (2015) "Using species richness and functional traits prediction to
 constrain assemblage predicitions from stacked species distribution models"
 \emph{Journal of Biogeography} 42(7):1255-1266
 \url{http://doc.rero.ch/record/235561/files/pel_usr.pdf}

 J.M. Calabrese, G. Certain, C.  Kraan, & C.F. Dormann (2014) "Stacking
 species distribution  models  and  adjusting  bias  by linking them to
 macroecological models." \emph{Global Ecology and Biogeography} 23:99-112
 \url{https://onlinelibrary.wiley.com/doi/full/10.1111/geb.12102}

 M. D. Crisp, S. Laffan, H. P. Linder & A. Monro (2001) "Endemism in the
 Australian flora"  \emph{Journal of Biogeography} 28:183-198
 \url{http://biology-assets.anu.edu.au/hosted_sites/Crisp/pdfs/Crisp2001_endemism.pdf}

 C. Liu, P. M. Berry, T. P. Dawson,  R. & G. Pearson (2005) "Selecting
 thresholds of occurrence in the prediction of species distributions."
 \emph{Ecography} 28:85-393
}
\seealso{
\code{\link{stack_modelling}} to build SSDMs.
}
