% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\alias{evaluate,Algorithm.SDM-method}
\alias{evaluate,MAXENT.SDM-method}
\alias{evaluate,Stacked.SDM-method}
\title{Evaluate}
\usage{
evaluate(obj, ...)

\S4method{evaluate}{Algorithm.SDM}(
  obj,
  cv,
  cv.param,
  final.fit.data = "all",
  bin.thresh = "SES",
  metric = NULL,
  thresh = 1001,
  Env,
  ...
)

\S4method{evaluate}{MAXENT.SDM}(
  obj,
  cv,
  cv.param,
  final.fit.data = "all",
  bin.thresh = "SES",
  metric = NULL,
  thresh = 1001,
  Env,
  ...
)

\S4method{evaluate}{Stacked.SDM}(obj, ...)
}
\arguments{
\item{obj}{Stacked.SDM. SSDM to evaluate}

\item{...}{arguments for internal use (get_model), such as argument lists to be passed to the source functions (e.g. glm.args=list(test="AIC",singular.ok=FALSE))}

\item{cv}{character. Method of cross-validation used to evaluate the SDM (see
details below).}

\item{cv.param}{numeric. Parameters associated to the method of
cross-validation used to evaluate the SDM (see details below).}

\item{final.fit.data}{strategy used for fitting the final model to be returned: 'holdout'= use same train and test data as in (last) evaluation, 'all'= train model with all data (i.e. no test data) or numeric (0-1)= sample a custom training fraction (left out fraction is set aside as test data)}

\item{bin.thresh}{character. Classification threshold (\code{\link[dismo]{threshold}}) used to binarize model predictions into presence/absence and compute the confusion matrix (including related scores such as TPR, TNR, omission rate, Kappa, etc.).}

\item{metric}{(deprecated) character. Classification threshold (\code{SDMTools::optim.thresh}) used to binarize model predictions into presence/absence and compute the confusion matrix (including related scores such as TPR, TNR, omission rate, Kappa, etc.).}

\item{thresh}{(deprecated) integer. Number of equally spaced thresholds in the interval 0-1 (\code{SDMTools::optim.thresh}).}

\item{Env}{raster object. Stacked raster object of environmental variables
(can be processed first by \code{\link{load_var}}).}
}
\value{
SDM/ESDM/SSDM evaluation in a data.frame
}
\description{
Evaluation of SDM or ESDM habitat suitability predictions or evalaution of
SSDM floristic composition with Pottier et al, 2013 method (see reference
below)
}
\examples{

\dontrun{
# Loading data
data(Env)
data(Occurrences)
# SSDM building
SSDM <- stack_modelling(c('CTA', 'SVM'), Occurrences, Env, rep = 1,
                       Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
                       Spcol = 'SPECIES')

# Evaluation
evaluate(SSDM)

}

}
\references{
Pottier, J., Dubuis, A., Pellissier, L., Maiorano, L., Rossier,
  L., Randin, C. F., Guisan, A. (2013). The .accuracy of plant assemblage
  prediction from species distribution models varies along environmental
  gradients. Global Ecology and Biogeography, 22(1), 52-63.
  https://doi.org/10.1111/j.1466-8238.2012.00790.x
}
