% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_diffexp.R
\name{find_diffexp}
\alias{find_diffexp}
\title{Find the expression ratio for each experimental sample for the specified gene.}
\usage{
find_diffexp(genes, srratio, srscore, metadata)
}
\arguments{
\item{genes}{character vector that can consist of gene IDs}

\item{srratio}{A dataframe of srratio}

\item{srscore}{A dataframe of srratio}

\item{metadata}{A dataframe of metadata}
}
\value{
Data frame of metadata with SRratio corresponding to the specified gene ID in the back row
}
\description{
This function retrieves SRratio (Stress Response ratio) values for one or
more specified genes across all experimental samples and combines them with
the corresponding sample metadata. In addition, the corresponding
SRscore (Stress Response score) values for the specified genes are returned.
The output is intended for downstream inspection and visualization of
gene-level expression patterns across experimental conditions.
}
\examples{
vr1 <- "control_sample"
vr2 <- "treated_sample"
grp <- "Series"

ebg <- expand_by_group(MetadataABA,
                       vr1,
                       vr2,
                       grp)

SRratio <- calcSRratio(TranscriptomeABA,
                             vr1,
                             vr2,
                             ebg,
                             is.log = 1)

SRscore <- calcSRscore(SRratio)

set.seed(1)
find_diffexp(sample(SRratio$ensembl_gene_id, 1), SRratio, SRscore, MetadataABA)

}
