% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneQuality.R
\docType{data}
\name{BoneQuality}
\alias{BoneQuality}
\title{Bone quality in South Koreans}
\format{
A data frame with 969 rows (one for each student) and 7 columns:
\describe{
  \item{Sex}{The sex of the subject; one of \code{M} (male) or \code{F} (female)}
  \item{Age}{The age of the subject, in years}
  \item{Height}{The height of the subject, in cm}
  \item{Weight}{The weight of the subject, in kg}
  \item{LumbarBMD}{The bone mass density of the lumbar spine, in g/square-cm}
  \item{HipBMD}{The bone mass density of the total hip, in g/square-cm}
  \item{NeckBMD}{The bone mass density of the femoral neck, in g/square-cm}
}
}
\source{
https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0260924#sec013
}
\usage{
data(BoneQuality)
}
\description{
Bone mass density of South Korean subjects, at three body locations.
}
\details{
Bone mass density and demographic information for 969 subjects
in South Korea.
}
\examples{
plot(HipBMD ~ factor(Sex), data = BoneQuality)

}
\references{
Kim, K. Y., & Kim, K. M. (2022). 
Similarities and differences between bone quality parameters, 
trabecular bone score and femur geometry. 
\emph{PLOS One}, \bold{17}(1), e0260924.
}
\keyword{datasets}
