#' Mumps and isolating
#' 
#' Whether students complied with isolation orders duration a mumps outbreak.
#' 
#' @docType data
#' 
#' @keywords datasets
#' 
#' @format A data frame with 8 rows and 3 columns:
#' \describe{
#'   \item{AgeGroup}{One of \code{1} (18 to 19), \code{2} (20 to 21) or \code{3} (Older than 22)}
#'   \item{Compliance}{One of \code{1} (complied with isolation order) or \code{2} (did not comply}
#'   \item{Counts}{The number of students in each cell}
#' }
#' 
#' @details 
#' The data provide the number of students complying and not complying 
#' with an isolation order during a mumps outbreak in Kansas in 2006.
#' 
#' @source 
#'  Soud, F. A., M. M. Cortese, A. T. Curns, P. J. Edelson, R. H. Bitsko, 
#'  H. T. Jordan, A. S. Huang, J. M. Villalon-Gomez, and G. H. Dayan. (2009). 
#'  "Isolation Compliance Among University Students During a Mumps Outbreak,
#'  Kansas 2006".
#'  \emph{Epidemiology & Infection}, \bold{137}(1): 30--37.
#' 
#' @usage 
#' data(Mumps)
#' 
#' @examples
#' barplot( xtabs(Counts ~ Compliance + AgeGroup, data = Mumps), 
#'          names.arg = c("18, 19", "20, 21", "22+"), 
#'          ylab = "Number of students")
#' 

"Mumps"
