% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateCalibratePerformanceMeasure.R
\name{mcalibrateControlLimit}
\alias{mcalibrateControlLimit}
\title{Calibration of the control limit for the selected chart}
\usage{
mcalibrateControlLimit(
  targetARL = NULL,
  targetMRL = NULL,
  n,
  m,
  nv,
  theta = NULL,
  Ftheta = NULL,
  dists = c("Normal", "Normal"),
  mu = c(0, 0),
  sigma = NULL,
  dists.par = matrix(c(0, 1, 1, 0, 1, 1), ncol = 2),
  correlation = 0,
  chart = "T2",
  chart.par = c(10),
  replicates = 50000,
  isParallel = FALSE,
  maxIter = 20,
  progress = TRUE,
  alignment = "unadjusted",
  constant = NULL,
  absolute = FALSE
)
}
\arguments{
\item{targetARL}{scalar. is the target ARL to calibrate. By default is set to NULL}

\item{targetMRL}{scalar. is the target ARL to calibrate. By default is set to NULL}

\item{n}{scalar. Subroup size}

\item{m}{scalar. Reference sample size}

\item{nv}{scalar. Number of variables to be generated.}

\item{theta}{vector. Value corresponding with the \code{Ftheta} quantile.}

\item{Ftheta}{vector. Quantile of the data distribution. The values that take are between (0,1).}

\item{dists}{list.  Select the}

\item{mu}{vector. Two elements of the vector the first one is the mean of the reference sample and the second one is the mean of the monitoring sample.}

\item{sigma}{scalar. Standard deviation of the desired distribution.}

\item{dists.par}{matrix  For each variable (column), specify
\itemize{
  \item{\code{par.location}: Location parameter of the desired distribution. Default 0.}
  \item{\code{par.scale}: Scale parameter of the desired distribution. Default 1.}
  \item{\code{par.shape}: Shape parameter of the desired distribution, Default 1.}
}
The number of columns must be the same as the number of variables.}

\item{correlation}{scalar. Corralation between variables.}

\item{chart}{character string. Selected type of chart. One option available: \code{"T2"}.
\describe{
  \item{T2 scheme: }{is \code{c(k)}, where \code{k} comes from \eqn{UCL = mu + k\sigma, LCL = mu - k\sigma.}}
}}

\item{chart.par}{vector. Control limit and other parameters of the selected chart.}

\item{replicates}{scalar. Number of replicates to get the ARL}

\item{isParallel}{logical. If \code{TRUE} the code runs in parallel according to the
number of cores in the computer,otherwise the code runs sequentially. Default \code{TRUE}.}

\item{maxIter}{scalar. is a numeric. The maximum number of iteration to take the calibration before stops}

\item{progress}{logical. If \code{TRUE} it shows the progress in the console.}

\item{alignment}{character string. Aligment of the data \code{X} and \code{Y}. Select from
\itemize{
  \item "unadjusted": nothing is sustracte from \code{X} and \code{Y} (default).
  \item "overallmean": overall mean is sustracted from \code{X} and \code{Y}.
  \item "overallmedian": overall median is sustracted from \code{X} and \code{Y}.
  \item "samplemean": mean from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "samplemedian": median from corresponding group (\code{X} and \code{Y}) is sustracted from its corresponing vector.
  \item "referencemean": mean from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "referencemedian": median from \code{Y} is subtracted from \code{X} and \code{Y}.
  \item "constantvalue": a constant value is subtracted from \code{X} and \code{Y}.
}}

\item{constant}{scalar. Only used when the \code{alignment} is selected "constantvalue". Default \code{NULL}.}

\item{absolute}{logical. If \code{TRUE}, the absolute aligned values are obtained. (Default \code{FALSE})}
}
\value{
Multiple output. Select by \code{output$}
\itemize{
  \item \code{objective.function}: scalar. The best solution obtained, in terms of the target ARL or MRL
  \item \code{par.value}: scalar. Which parameter of the chart reach this best solution
  \item \code{found}: boolean. Is TRUE if in the \code{maxIter} is reached the desired +-5% of target ARL, or MRL.
}
}
\description{
The methodology used to calibrate the control limit
for the SNS chart depending on the selected chart
}
\note{
The argument \code{chart.par} in this function correspond to the initial parameters to start the calibration.
}
\examples{
n <- 5 # subgroup size
m <- 10 # reference-sample size
dists <- c("Normal", "Normal") # distribution
mu <- c(0, 0) # c(reference sample mean, monitoring sample mean)
nv <- 2 # number of variables
#### Other Parameters
replicates <- 2
targetARL <- 200
isParallel = FALSE
maxIter <- 2
#### Control chart parameters
chart <- "T2"
chart.par <- c(0.005)
t2 <- mcalibrateControlLimit(targetARL = targetARL,n = n, m = m, nv = nv, theta = NULL,
  Ftheta = NULL, dists = dists, mu = mu, chart.par = chart.par,
  replicates = replicates, chart = chart, isParallel = isParallel,
  maxIter = maxIter
)

}
