% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnivariateRandomNumberGenerator.R
\name{getDist}
\alias{getDist}
\title{Random Observations Generator}
\usage{
getDist(
  n,
  dist,
  mu,
  sigma,
  par.location = 0,
  par.scale = 1,
  par.shape = 1,
  dist.par = NULL,
  rounding.factor = NULL
)
}
\arguments{
\item{n}{scalar. Number of observations to be generated.}

\item{dist}{character string. Select from:
\itemize{
  \item{"Uniform: Continuous Uniform distribution .}
  \item{"Normal": Normal distribution (default).}
  \item{"Normal2": Squared Normal distribution (also known as Chi-squared).}
  \item{"DoubleExp": Double exponential distribution (also known as Laplace distribution).}
  \item{"DoubleExp2": Double exponential squared distribution from a \code{DoubleExp(0,1)}.}
  \item{"LogNormal": Lognormal distribution.}
  \item{"Gamma": Gamma distribution.}
  \item{"Weibull": Weibull distribution.}
  \item{"t": Student-t distribution.}
}}

\item{mu}{scalar. Expected value of the desired distribution.}

\item{sigma}{scalar. Standard deviation of the desired distribution.}

\item{par.location}{scalar. Location parameter of the desired distribution. Default 0**.}

\item{par.scale}{scalar. Scale parameter of the desired distribution. Default 1**.}

\item{par.shape}{scalar. Shape parameter of the desired distribution, Default 1.}

\item{dist.par}{vector. Overwrite \code{par.location}, \code{par.scale}, \code{par.shape}. Depends on the distribution (default \code{NULL}):
\itemize{
  \item{"Uniform: no matter how is defined always gives numbers between 0 and 1.}
  \item{"Normal": c(location, scale).}
  \item{"Normal2": c(location, scale).}
  \item{"DoubleExp": c(location, scale).}
  \item{"DoubleExp2": c(location, scale).}
  \item{"LogNormal": c(location, scale).}
  \item{"Gamma": c(scale, shape).}
  \item{"Weibull": c(shape, scale).}
  \item{"t": c(degrees of freedom).}
}}

\item{rounding.factor}{scalar. positive value that determine the range between two consecutive rounded values.}
}
\value{
A vector \code{x} with \code{n} observations generated following the selected distribution with its parameters.
}
\description{
Random observations generator selected from several distributions with user defined mean and variance.
}
\section{**Note}{

\itemize{
  \item{For "Lognormal", \code{par.location} and \code{par.scale} correspond to the location and scale parameters of the normal
    distribution that generales the lognormal. Hence, in this case they are the logmean and
    the logsigma parameters}
  \item{For "Normal2" and "DoubleExp2", \code{par.location} and \code{par.scale} correspond
    correspond to the location and scale parameters of the normal and double exponential
    that are used to generates their squared forms.}
}
}

\examples{
getDist(1, "Normal", 0, 1)
}
