#' Data from Example 8.2 Qiu (2014).
#'
#' A dataset containing the data set used in Example 8.2 on page 323 of Qiu (2014).
#'
#' @format A data frame with 150 rows (30 batches of size equals to 5)
#' \describe{
#'  \item{X}{observations of all batches}
#'  \item{X.id}{id of each observation of the batch}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example82.dat}
"example82"

#' Data from Example 8.4 Qiu (2014).
#'
#' A dataset containing the data set used in Example 8.4 of Qiu (2014).
#'
#' @format A data frame with 150 rows (30 batches of size equals to 5)
#' \describe{
#'  \item{X}{observations of all batches}
#'  \item{X.id}{id of each observation of the batch}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example84.dat}
"example84"

#' Data from Example 8.7 on page 339 Qiu (2014).
#'
#' A dataset containing the data set used in Example 8.7 on page 339 of Qiu (2014).
#'
#' @format A data frame with 86 rows (86 batches of size equals to 1)
#' \describe{
#'  \item{X}{observations of all batches}
#'  \item{X.id}{id of each observation of the batch}
#'  \item{Y}{reference sample of size equals to 14}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example87.dat}
"example87"

#' Data from Example 6.5 on page 246 Qiu (2014).
#'
#' A dataset containing the data set used in Example 6.5 on page 246 of Qiu (2014).
#'
#' @format A data frame with 30 rows and 5 columns:
#' \describe{
#'  \item{x}{first 9 observations are the reference sample. Batch size equals to 1.}
#'  \item{Wn}{Wn}
#'  \item{Sn2}{Sn2}
#'  \item{Bmax}{Bmax}
#'  \item{hn}{hn}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example65.dat}
"example65"

#' Data from Example 4.9 Qiu (2014).
#'
#' A dataset containing the data set used in Example 4.9 of Qiu (2014).
#'
#' @format A data frame with 50 rows and 6 columns:
#' \describe{
#'  \item{Y1}{Reference sample of the first data set. 10 batches are N(0,1)}
#'  \item{X1}{Monitoring sample of the first data set. 10 batches are N(1,1).}
#'  \item{Y2}{Reference sample of the second data set. 10 batches are N(0,1)}
#'  \item{X2}{Monitoring sample of the second data set. 10 batches are N(0,2^2).}
#'  \item{X.id}{id of each observation of the batch for the second data set.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example49.dat}
"example49"

#' Data from Example 8.1 on page 319 Qiu (2014).
#'
#' A dataset containing the data set used in Example 8.1 on page 319 of Qiu (2014).
#'
#' @format A data frame with 300 rows (30 batches of size equals to 10)
#' \describe{
#'  \item{X}{observations of all batches}
#'  \item{X.id}{id of each observation of the batch}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example81.dat}
"example81"

#It consists of 30 batches of observations where each batch has 6 observations

#' Data from Example 8.3 on page 326 Qiu (2014).
#'
#' A dataset containing the data set used in Example 8.3 on page 326 of Qiu (2014).
#'
#' @format A data frame with 180 rows (30 batches of size equals to 6)
#' \describe{
#'  \item{X}{observations of all batches}
#'  \item{X.id}{id of each observation of the batch}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example81.dat}
"example83"

#' Data from Example 8.5 Qiu (2014).
#'
#' A dataset containing the data set used in Example 8.5 of Qiu (2014).
#'
#' @format A data frame with 300 rows (30 batches of size equals to 10)
#' \describe{
#'  \item{X}{observations of all batches}
#'  \item{X.id}{id of each observation of the batch}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example85.dat}
"example85"

#' Data from Example 9.1 on page 369 Qiu (2014).
#'
#' A dataset containing the data set used in Example 9.1 on page 369 of Qiu (2014).
#'
#' @format The data (X,Y) consist of 20 batches with 50 observations in each batch.
#'
#' \describe{
#'  \item{V1}{1st batch.}
#'  \item{V2}{2nd batch.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example91.dat}
"example91"

#' Data from Example 9.3 Qiu (2014).
#'
#' A dataset containing the data set used in Example 9.3 of Qiu (2014).
#'
#' @format The data (X,Y) consist of 20 batches with 10 observations in each batch.
#'
#' \describe{
#'  \item{X}{1st batch.}
#'  \item{X.1}{2nd batch.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example93.dat}
"example93"

#' Data from Example 7.1 Qiu (2014).
#'
#' A dataset containing the data set used in Example 7.1 of Qiu (2014).
#'
#' @format The data (X1,X2,X3) consist of 30 observations each variable.
#'
#' \describe{
#'  \item{X}{1st batch.}
#'  \item{X.1}{2nd batch.}
#'  \item{X.2}{3rd batch.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example71.dat}
"example71"

#' Data from Example 7.4(a) Qiu (2014).
#'
#' A dataset containing the data set used in Example 7.4(a) of Qiu (2014).
#'
#' @format The data (X1,X2,X3) consist of 30 observations each variable.
#'
#' \describe{
#'  \item{X}{1st batch.}
#'  \item{X.1}{2nd batch.}
#'  \item{X.2}{3rd batch.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example74a.dat}
"example74a"

#' Data from Example 7.4(b) Qiu (2014).
#'
#' A dataset containing the data set used in Example 7.4(b) of Qiu (2014).
#'
#' @format The data (X1,X2,X3) consist of 30 observations each variable.
#'
#' \describe{
#'  \item{X}{1st batch.}
#'  \item{X.1}{2nd batch.}
#'  \item{X.2}{3rd batch.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example74b.dat}
"example74b"

#' Data from Example 7.4(c) Qiu (2014).
#'
#' A dataset containing the data set used in Example 7.4(c) of Qiu (2014).
#'
#' @format The data (X1,X2,X3) consist of 30 observations each variable.
#'
#' \describe{
#'  \item{X}{1st batch.}
#'  \item{X.1}{2nd batch.}
#'  \item{X.2}{3rd batch.}
#' }
#' @source \url{https://users.phhp.ufl.edu/pqiu/research/book/spc/data/example74c.dat}
"example74c"
