% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.SLRMss.R
\name{fitted.SLRMss}
\alias{fitted.SLRMss}
\title{Extract model fitted values for a SLRMss object}
\usage{
\method{fitted}{SLRMss}(object, H0 = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{SLRMss}.}

\item{H0}{If TRUE, choose the fitted values under null hypothesis, if FALSE, choose the fitted values under alternative hypothesis (default).}

\item{...}{Currently ignored.}
}
\value{
Fitted values extracted from the SLRMss object.
}
\description{
This function provides the fitted values of a SLRMss model.
}
\examples{
data(orange)
fit <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student", xi=3,
testingbeta="xanthangum", statistic="LR", data=orange)
fitted(fit)
}
