% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.TrainedSLOPE}
\alias{summary.TrainedSLOPE}
\title{Summarize TrainedSLOPE Model}
\usage{
\method{summary}{TrainedSLOPE}(object, ...)
}
\arguments{
\item{object}{an object of class \code{'TrainedSLOPE'}, typically from a call to
\code{\link[=cvSLOPE]{cvSLOPE()}} or \code{\link[=trainSLOPE]{trainSLOPE()}}}

\item{...}{other arguments (currently ignored)}
}
\value{
An object of class \code{'summary_TrainedSLOPE'} with the following
components:
\item{call}{the call that produced the model}
\item{measure}{the performance measure(s) used}
\item{optima}{optimal parameter values and corresponding performance}
\item{n_folds}{number of cross-validation folds}
\item{n_repeats}{number of cross-validation repeats}
\item{n_models}{total number of models evaluated}
}
\description{
Produces a summary of a trained SLOPE model from cross-validation,
including information about the optimal parameters and performance metrics.
}
\examples{
tune <- cvSLOPE(
  subset(mtcars, select = c("mpg", "drat", "wt")),
  mtcars$hp,
  q = c(0.1, 0.2),
  n_folds = 5
)
summary(tune)

}
\seealso{
\code{\link[=cvSLOPE]{cvSLOPE()}}, \code{\link[=trainSLOPE]{trainSLOPE()}}, \code{\link[=print.summary_TrainedSLOPE]{print.summary_TrainedSLOPE()}}

Other model-tuning: 
\code{\link{cvSLOPE}()},
\code{\link{plot.TrainedSLOPE}()},
\code{\link{refit}()},
\code{\link{trainSLOPE}()}
}
\concept{model-tuning}
