% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sip.R
\name{sip}
\alias{sip}
\title{Single-iteration permutation for large-scale biobank data}
\usage{
sip(
  df = NULL,
  id.var = NULL,
  sex.var = NULL,
  male.val = NULL,
  female.val = NULL,
  geno.vars = NULL,
  within.sex = TRUE,
  seed = NULL
)
}
\arguments{
\item{df}{Data frame}

\item{id.var, sex.var}{Strings}

\item{male.val, female.val}{Strings or integers}

\item{geno.vars}{Character vectors}

\item{within.sex}{Boolean, defaults to TRUE}

\item{seed}{Number}
}
\value{
Data frame
}
\description{
This function performs the basic permutation for permuting phenotype
vectors in biobank data.
}
\details{
The function requires the following inputs:

1) A sample-by-variable dataframe with phenotypes and covariates.
Column names should include an ID variable, sex variable,
genotypic covariate names, phenotypic covariate names,
and phenotype names. (N.B. a secondary ID variable can be included
in the genotypic covariate names.)

2) A string identifying the ID variable name (e.g., id.var="ID").

3) A vector of genotypic covariates
(e.g., geno.vars=c("ID2","Batch","PC1","PC2",...)).

4) Optional: within.sex = FALSE. Default is within.sex = TRUE
and will permute males and females separately.

5) If within.sex = TRUE (the default), a string identifying the
sex variable name (e.g., sex.var="Inferred_Sex").

6) If within.sex = TRUE (the default), male and female values
in the sex vector (e.g., male.val=1, female.val=2).

7) Optional: a seed for sampling. If a seed is not provided, one will be
chosen randomly during the sampling process (e.g., seed=123).

8) N.B. Any column names not specified in (2)-(6) are assumed to be
phenotypes or phenotypic covariates.
}
\examples{
sip(df = sip_exampleData, id.var = "IID", sex.var = "SEX", male.val = 1,
female.val = 2, geno.vars = c("FID","ANCESTRY","BATCH",paste0("PC",1:4)))
}
