% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_logical.R
\name{check_logical_parameter}
\alias{check_logical_parameter}
\title{General checker for parameter-specific logical rules}
\usage{
check_logical_parameter(
  data,
  param_name,
  condition,
  return_df = FALSE,
  return_logical = FALSE
)
}
\arguments{
\item{data}{A data frame. Must contain columns \code{parameter} and \code{value}.}

\item{param_name}{Character; the name of the parameter to check.}

\item{condition}{A function that takes a numeric vector of values and
returns a logical vector (TRUE for rows considered problematic).}

\item{return_df}{Logical. If TRUE, return a plain data.frame of problematic rows.}

\item{return_logical}{Logical. If TRUE, return a logical vector of length nrow(data).
Overrides return_df.}
}
\value{
A DT datatable, a data.frame, a logical vector, or NULL if no problems found.
}
\description{
This function checks for logical rule violations in benthos/epibenthos data
by applying a user-defined condition to values for a given parameter.
It is intended to replace the old family of \verb{check_*_*_logical()} functions.
}
\examples{
# Example dataset
df <- dplyr::tibble(
  station_name = c("A1", "A2", "A3", "A4"),
  sample_date = as.Date("2023-05-01") + 0:3,
  sample_id = 101:104,
  parameter = c("Biomass", "Biomass", "Abundance", "Biomass"),
  value = c(5, -2, 10, 0)
)

# 1. Check that Biomass is never negative
check_logical_parameter(df, "Biomass", function(x) x < 0,  return_df = TRUE)

# 2. Same check, but return problematic rows as a data frame
check_logical_parameter(df, "Biomass", function(x) x < 0, return_df = TRUE)

# 3. Return logical vector marking problematic rows
check_logical_parameter(df, "Biomass", function(x) x < 0, return_logical = TRUE)

# 4. Check that Abundance is not zero (no problems found -> returns NULL)
abundance_check <- check_logical_parameter(df, "Abundance", function(x) x == 0)
print(abundance_check)

}
