% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_penalty.R
\name{process.penalty}
\alias{process.penalty}
\title{Process the arguments about the sparse group penalty}
\usage{
process.penalty(penalty, pvar, pgr, vargamma, grgamma, vartau, grtau, alpha)
}
\arguments{
\item{penalty}{A string that specifies the sparse group penalty to be used.}

\item{pvar}{A string that specifies the penalty used at the variable level.}

\item{pgr}{A string that specifies the penalty used at the group level.}

\item{vargamma}{An integer that defines the value of gamma for the penalty at the variable level.}

\item{grgamma}{An integer that specifies the value of gamma for the penalty at the group level.}

\item{vartau}{An integer that defines the value of tau for the penalty at the variable level.}

\item{grtau}{An integer that specifies the value of tau for the penalty at the group level.}

\item{alpha}{Tuning parameter for the mixture of penalties at group and variable level.
A value of 0 results in a selection at group level, a value of 1
results in a selection at variable level and everything in between
is bi-level selection.}
}
\value{
A list of two integers indicating the penalty for the C++ code.
}
\description{
A function that checks arguments about the penalty and translates them to integer (for the C++ code).
}
