% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UfsCov_par.R
\name{UfsCov_par}
\alias{UfsCov_par}
\title{UfsCov algorithm for unsupervised feature selection}
\usage{
UfsCov_par(data, ncores=2)
}
\arguments{
\item{data}{Data of class: \code{matrix} or \code{data.frame}.}

\item{ncores}{Number of cores to use (by default: \code{ncores=2}).}
}
\value{
A list of two elements:
 \itemize{
  \item \code{CovD} a vector containing the coverage measure of
  each step of the SFS.
  \item \code{IdR} a vector containing the added variables during
  the selection procedure.
  }
}
\description{
Applies the UfsCov algorithm based on the space filling concept,
by using a sequatial forward search (SFS).This function
offers a parellel computing.
}
\details{
Since the algorithm is based on pairwise distances, and
according to the computing power of your machine, large number of
data points needs more memory. See \code{\link{UfsCov_ff}} for memory
efficient storage of large data on disk and fast access (by using the
\code{ff} and the \code{ffbase} packages).
}
\note{
The algorithm does not deal with missing values and constant
features. Please make sure to remove them. Note that it is not recommanded to
use this function with small data, it takes more time than using the
standard \code{\link{UfsCov}} function.
}
\examples{
N <- 800
dat<-Infinity(N)
Results<- UfsCov_par(dat,ncores=2)

cou<-colnames(dat)
nom<-cou[Results[[2]]]
par(mfrow=c(1,1), mar=c(5,5,2,2))
names(Results[[1]])<-cou[Results[[2]]]
plot(Results[[1]] ,pch=16,cex=1,col="blue", axes = FALSE,
xlab = "Added Features", ylab = "Coverage measure")
lines(Results[[1]] ,cex=2,col="blue")
grid(lwd=1.5,col="gray" )
box()
axis(2)
axis(1,1:length(nom),nom)
which.min(Results[[1]])

\dontrun{

N<-5000
dat<-Infinity(N)

## Little comparison:
system.time(Uf<-UfsCov(dat))
system.time(Uf.p<-UfsCov_par(dat, ncores = 4))

}
}
\references{
M. Laib and M. Kanevski (2017). Unsupervised Feature Selection Based on Space
Filling Concept, \href{https://arxiv.org/abs/1706.08894}{arXiv:1706.08894}.
}
\seealso{
\code{\link{UfsCov}}, \code{\link{UfsCov_ff}}
}
\author{
Mohamed Laib \email{Mohamed.Laib@unil.ch}
}
