% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Infinity.R
\name{Infinity}
\alias{Infinity}
\title{Simulated dataset}
\usage{
Infinity(n=1000)
}
\arguments{
\item{n}{Number of generated data points (by default: \code{n=1000}).}
}
\value{
A \code{data.frame} of simulated dataset, with \eqn{7} features
(\eqn{4} of them are redundants)
}
\description{
Generates a simulated dataset (the Infinity dataset)
}
\examples{
infinity<-Infinity(n=1000)
plot(infinity$x1,infinity$x2)

\dontrun{

#### Visualisation of the infinity dataset (3D) ####
require(rgl)
require(colorRamps)

c <- cut(infinity$z,breaks=100)
cols <- matlab.like(100)[as.numeric(c)]
plot3d(infinity$x1,infinity$x2,infinity$z,radius=0.01, col=cols,
type="s",xlab="x1",ylab="x2",zlab="z",box=F)
grid3d(c("x","y","z"),col="black",lwd=1)

}
}
\author{
Mohamed Laib \email{Mohamed.Laib@unil.ch}
}
