% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{predict_cdf_forest}
\alias{predict_cdf_forest}
\title{Predict SFHNV random forest conditional CDF values}
\usage{
predict_cdf_forest(
  forest,
  observations,
  d_values,
  parallel = TRUE,
  agg = "mean",
  trim_prop = 0.05
)
}
\arguments{
\item{forest}{A list of trees produced by \code{\link[=build_random_forest]{build_random_forest()}}.}

\item{observations}{Data frame of new observations.}

\item{d_values}{Scalar or vector of demand thresholds.}

\item{parallel}{Logical; if \code{TRUE} and \code{future.apply} is available, predict in parallel.}

\item{agg}{Aggregation strategy across trees (\code{"mean"}, \code{"median"}, or \code{"trimmed"}).}

\item{trim_prop}{Trimming proportion when \code{agg = "trimmed"}.}
}
\value{
Numeric vector of CDF estimates.
}
\description{
Predict SFHNV random forest conditional CDF values
}
\examples{
data <- data.frame(x1 = rnorm(100), x2 = rnorm(100), D = rnorm(100), Q = rnorm(100))
forest <- build_random_forest(data, num_trees = 3, min_size = 15)
predict_cdf_forest(forest, data, d_values = 0)
}
