% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCB_gls_geospatial.R
\name{SCB_gls_geospatial}
\alias{SCB_gls_geospatial}
\title{Construct Simultaneous Confidence Bands for a Spatial Generalized Least Squares Model}
\usage{
SCB_gls_geospatial(
  sp_list,
  level = NULL,
  data_fit = NULL,
  w = NULL,
  correlation = NULL,
  corpar = NULL,
  groups = NULL,
  V = NULL,
  alpha = 0.1,
  N = 1000,
  mask = NULL
)
}
\arguments{
\item{sp_list}{A list containing the spatial coordinates and the observations.
Should include the following components:
\itemize{
\item \code{x}: A numeric vector of x-coordinates (e.g., longitude).
\item \code{y}: A numeric vector of y-coordinates (e.g., latitude).
\item \code{obs}: A 3D array of observations with dimensions
\code{length(x)} × \code{length(y)} × \code{n}.
}}

\item{level}{A optional numeric threshold value used to test whether the
estimated mean surface significantly deviates from it. Default is NULL.}

\item{data_fit}{A design matrix used to fit the generalized least squares
(GLS) model. Each row corresponds to an observation, and each column to a covariate
to be included in the model. Outcome/observation should not be included.
The first column is typically an intercept column,
which will contain only 1s, if an intercept is included in the model.
Categorical variables in \code{data_fit} should be converted to dummy variables.
Default is \code{matrix(1, n, 1)} (only keep the intercept term)}

\item{w}{A numeric vector specifying the target function for constructing the SCB,
by giving a linear combination of the regression coefficients in the GLS model.
Default is \code{matrix(1, 1, 1)}, will only construct the SCB for the first regression
coefficient.}

\item{correlation}{A character string specifying the name of
the correlation structure (e.g., \code{"corAR1"}, \code{"corCompSymm"})
to be used in the GLS model. If \code{NULL}, no correlation structure is assumed.}

\item{corpar}{A list containing parameters to be passed to
the correlation structure function specified in \code{correlation}.}

\item{groups}{A vector of group identifiers used to define
the within-group correlation structure (e.g., repeated measures, time blocks).
If not specified, defaults to \code{rep(1, n)}, assuming all observations
belong to a single group.}

\item{V}{An optional array of known covariance matrices of
shape \code{[length(x), length(y), n, n]}, where each \code{V[i,j,,]}
corresponds to the covariance matrix for the observations at spatial location
\code{(x[i], y[j])}. If V is given, then the GLS model will be fitted based on V.
Otherwise, the GLS model will be fitted based on correlation structure.
If neither is provided, the model reduces to ordinary least squares (OLS) regression.}

\item{alpha}{A numerical value specifying the confidence level
for the Simultaneous Confidence Bands. Defalut is \code{0.1}.}

\item{N}{An integer specifying the number of bootstrap samples to
construct the Simultaneous Confidence Bands. Default is \code{1000}.}

\item{mask}{An optional logical matrix same dimensions as
\code{c(length(sp_list$x), length(sp_list$y))}, indicating spatial locations to
include in the SCB computation. Non-included locations (e.g., water areas)
should be set to 0 or \code{NA}.
Default is \code{array(1, dim = c(length(sp_list$x), length(sp_list$y)))}}
}
\value{
A list containing the following components:
\describe{
\item{\code{scb_up}}{A matrix of upper bounds for
the simultaneous confidence bands at each spatial location
corresponding to the target function specified by \code{w}.}
\item{\code{scb_low}}{A matrix of lower bounds for
the simultaneous confidence bands at each spatial location
corresponding to the target function specified by \code{w}.}
\item{\code{mu_hat}}{A matrix of estimated mean values at each spatial location
corresponding to the target function specified by \code{w}.}
\item{\code{norm_est}}{A matrix of standardized test statistics \code{(mu_hat - level) / SE}.}
\item{\code{thres}}{The bootstrap threshold used to construct the confidence bands.}
\item{\code{x}}{The vector of x-coordinates corresponding to the columns of the spatial grid.}
\item{\code{y}}{The vector of y-coordinates corresponding to the rows of the spatial grid.}
}
}
\description{
Construct Simultaneous Confidence Bands for a Spatial Generalized Least Squares Model
}
\examples{
data(climate_data)
# Construct confidence sets for the increase of the mean temperature (June-August)
# in North America between the 20th and 21st centuries
\donttest{
temp = SCB_gls_geospatial(sp_list = climate_data$Z, level = 2, data_fit = climate_data$X,
                       w = c(1,0,0,0), correlation = climate_data$correlation,
                       mask = climate_data$mask, alpha = 0.1)
}

example_list <- list(x = climate_data$Z$x[50:60], y = climate_data$Z$y[40:50],
obs = climate_data$Z$obs[50:60, 40:50,])
temp = SCB_gls_geospatial(sp_list = example_list, level = 2, data_fit = climate_data$X,
                       w = c(1,0,0,0), correlation = NULL,
                       mask = NULL, alpha = 0.1, N = 50)

}
\references{
Sommerfeld, M., Sain, S., & Schwartzman, A. (2018).
Confidence regions for spatial excursion sets from repeated random field observations, with an application to climate.
\emph{Journal of the American Statistical Association}, 113(523), 1327–1340.
\doi{10.1080/01621459.2017.1341838}

Ren, J., Telschow, F. J. E., & Schwartzman, A. (2024).
Inverse set estimation and inversion of simultaneous confidence intervals.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 73(4), 1082–1109.
\doi{10.1093/jrsssc/qlae027}
}
