% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{celltype_expression}
\alias{celltype_expression}
\title{Compute cell type specific gene expression}
\usage{
celltype_expression(bulk, ref, phenodata, prop, ...)
}
\arguments{
\item{bulk}{a matrix-like object of bulk RNA-seq data with rows representing genes, columns representing samples}

\item{ref}{a matrix-like object of scRNA-seq data with rows representing genes, columns representing cells.}

\item{phenodata}{a data.frame with rows representing cells, columns representing cell attributes. It should at least contain the first two
columns as:
\enumerate{
 \item cell barcodes
 \item cell types
}}

\item{prop}{a matrix-like object of cell proportion values with rows representing cell types, columns representing samples.}

\item{...}{additional parameters passed to \code{create.RCTD} from \code{spacexr}.}
}
\value{
a list with length equal to number of unique cell types in phenodata. Each element in the list represents gene expression matrix for each unique cell type.
}
\description{
Compute cell type specific gene expression based on predicted cell proportions and reference data.
}
\details{
this function is inspired by cell-type specific gene expression estimation for doublet mode in \code{spacexr}. See examples from \code{\link{run_de}}.
}
