% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digest_to_checksum.R
\name{digest_to_checksum}
\alias{digest_to_checksum}
\title{Computes an checksum from columns}
\usage{
digest_to_checksum(.data, col = "checksum", exclude = NULL, warn = TRUE)
}
\arguments{
\item{.data}{(\code{data.frame(1)}, \code{tibble(1)}, \code{data.table(1)}, or \code{tbl_dbi(1)})\cr
Data object.}

\item{col}{(\code{character(1)})\cr
Name of the column to put the checksums in. Will be generated if missing.}

\item{exclude}{(\code{character()})\cr
Columns to exclude from the checksum generation.}

\item{warn}{(\code{logical(1)})\cr
Warn if \code{col} exists in the input data?}
}
\value{
.data with a checksum column added.
}
\description{
Computes an checksum from columns
}
\details{
In most cases, the md5 algorithm is used to compute the checksums.
For Microsoft SQL Server, the SHA-256 algorithm is used.
}
\examples{
  digest_to_checksum(mtcars)
}
