% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_rec_model.R
\docType{class}
\name{rec_model}
\alias{rec_model}
\title{Azure product recommendations model class}
\format{
An R6 object of class \code{rec_model}.
}
\description{
Class representing an individual product recommendations (SAR) model.
}
\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a model object. See 'Initialization' for more details.
\item \code{delete(confirm=TRUE)}: Delete the model.
\item \code{user_predict(userdata, k=10)}: Get personalised recommendations from the model. See 'Recommendations' for more details.
\item \code{item_predict(item, k=10)}: Get item-to-item recommendations from the model. See 'Recommendations' for more details.
\item \code{get_model_url()}: Get the individual service URL for this model.
}
}

\section{Initialization}{

Generally, the easiest way to initialize a new model object is via the \code{get_model()} and \code{train_model()} methods of the \code{rec_endpoint} class, which will handle all the gory details.
}

\section{Recommendations}{

These arguments are used for obtaining personalised and item-to-item recommendations.
\itemize{
\item \code{userdata}: The input data on users for which to obtain personalised recommendations. This can be:
\enumerate{
\item A character vector of user IDs. In this case, personalised recommendations will be computed based on the transactions in the training data, \emph{ignoring} any transaction event IDs or weights.
\item A data frame containing transaction item IDs, event types and/or weights, plus timestamps. In this case, all the transactions are assumed to be for a single (new) user. If the event types/weights are absent, all transactions are assigned equal weight.
\item A data frame containing user IDs and transaction details as in (2). In this case, the recommendations are based on both the training data for the given user(s), plus the new transaction details.
}
\item \code{item}: A vector of item IDs for which to obtain item-to-item recommendations.
\item \code{k}: The number of recommendations to return. Defaults to 10.
}

Both the \code{user_predict()} and \code{item_predict()} methods return a data frame with the top-K recommendations and scores.
}

\examples{
\dontrun{

# get a recommender endpoint and previously-trained model
rec_endp <- rec_endpoint$new("myrecusacvjwpk4raost", admin_key="key1", rec_key="key2")
rec_model <- rec_endp$get_model("model1")

data(ms_usage)

# item recommendations for a set of user IDs
users <- unique(ms_usage$user)[1:5]
rec_model$user_predict(users)

# item recommendations for a set of user IDs and transactions (assumed to be new)
user_df <- subset(ms_usage, user \%in\% users)
rec_model$user_predict(user_df)

# item recomendations for a set of item IDs
items <- unique(ms_usage$item)[1:5]
rec_model$item_predict(items)

}
}
\seealso{
\link{az_rec_service} for the service backend, \link{rec_endpoint} for the client endpoint

\href{https://github.com/Microsoft/Product-Recommendations/blob/master/doc/api-reference.md}{API reference} and \href{https://github.com/Microsoft/Product-Recommendations/blob/master/doc/sar.md}{SAR model description} at the Product Recommendations API repo on GitHub
}
