% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SADISA_sim.R
\name{SADISA_sim}
\alias{SADISA_sim}
\title{Simulates species abundance data}
\usage{
SADISA_sim(parsmc, ii, jj, model = c("pm", "dl"), mult = "single",
  nsim = 1)
}
\arguments{
\item{parsmc}{The model parameters. For the point mutation (pm) model this is theta and I. For the protracted
model (pr) this is theta, phi and I. For the density-dependent model (dd) - which can also be interpreted as
the per-species speciation model, this is theta and alpha.}

\item{ii}{The I parameter. When I is a vector, it is assumed that each value
describes a sample or a guild depending on whether mult == 'ms' or mult == 'mg'. When mult = 'both',
a list of lists must be specified, with each list element relates to a sample and contains a list of values across guilds.}

\item{jj}{the sample sizes for each sample and each guild. Must have the same structure as ii}

\item{model}{the chosen combination of metacommunity model and local community model
as a vector, e.g. c('pm','dl') for a model with point mutation in the metacommunity and
dispersal limitation.
The choices for the metacommunity model are: 'pm' (point mutation), 'rf' (random fission),
'pr' (protracted speciation), 'dd' (density-dependence).
The choices for the local community model are: 'dl' (dispersal limitation), 'dd' (density-dependence).}

\item{mult}{When set to 'single', the loglikelihood of a single abundance vector will be computed
When set to 'mg' the loglikelihood for multiple guilds is computed.
When set to 'ms' the loglikelihood for multiple samples from the same metacommunity is computed.
When set to 'both' the loglikelihood for multiple guilds within multiple samples is computed.}

\item{nsim}{Number of simulations to perform}
}
\value{
abund abundance vector, a list of abundance vectors, or a list of lists of abundance vectors,
or a list of lists of lists of abundance vectors
The first layer of the lists corresponds to different simulations
When mult = 'mg', each list contains a list of abundance vectors for different guilds.
When mult = 'ms', each list contains a list of abundance vectors for different samples
from the same metacommunity. In this case the vectors should have equal lengths and may contain
zeros because there may be species that occur in multiple samples and species that do not occur
in some of the samples.
When mult = 'both', each list will be a list of lists of multiple guilds within a sample
}
\description{
Simulates species abundance data using the independent-species approach
}
\details{
Not all combinations of metacommunity model and local community model have been implemented yet.
because this requires checking for numerical stability of the integration. The currently available model combinations are c('pm','dl').
}
\references{
Haegeman, B. & R.S. Etienne (2017). A general sampling formula for community structure data. Methods in Ecology & Evolution 8: 1506-1519. doi: 10.1111/2041-210X.12807
}
\keyword{model}
\keyword{species-abundance-distribution}
