% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_consensus.R
\name{flag_consensus}
\alias{flag_consensus}
\title{Get consensus across multiple flags}
\usage{
flag_consensus(
  occ,
  flags,
  consensus_rule = "all_true",
  flag_name = "consensus_flag",
  remove_flag_columns = FALSE
)
}
\arguments{
\item{occ}{(data.frame or data.table) a dataset with occurrence records that
has been processed by two or more flagging functions.}

\item{flags}{(character) a string vector with the names of the flags to be
used in the consensus evaluation. See details for see the options.}

\item{consensus_rule}{(character) A string specifying how the consensus
should be computed. Options are \code{"all_true"} (record is considered valid only
when \strong{all} flags are \code{TRUE} or \code{"any_true"}(record is considered valid when
\strong{at least one} flag is \code{TRUE}. Default is \code{"all_true"}}

\item{flag_name}{(character) name of the column that will store the
consensus result. Default is \code{"consensus_flag"}.}

\item{remove_flag_columns}{(logical) whether to remove the original flag
columns specified in \code{flags} from the final output. Default is \code{FALSE}.}
}
\value{
The original \code{occ} with an additional logical column defined by
\code{flag_name}, indicating the consensus result based on the selected
\code{consensus_rule}.
}
\description{
This functions creates a new column representing the consensus across
multiple flag columns. The consensus can be computed in two ways:
\itemize{
\item \code{"all_true"}: A record is considered valid (\code{TRUE}) only if \strong{all}
specified flag are valid (\code{TRUE}).
\item \code{"any_true"}: A record is considered valid (\code{TRUE}) if \strong{at least one}
specified flag is valid (\code{TRUE}).
}
}
\details{
The following flags are available:  correct_country, correct_state,
cultivated, fossil, inaturalist, faunabr, florabr, wcvp, iucn, duplicated,
thin_geo, thin_env, year, .val, .equ, .zer, .cap, .cen, .sea, .urb, .otl,
.gbf, .inst, and .aohi.
}
\examples{
# Load example data
data("occ_flagged", package = "RuHere")

# Get consensus using florabr, wcvp, and iucn flags
 # Valid (TRUE) only when all flags are TRUE
occ_consensus_all <- flag_consensus(occ = occ_flagged,
                                    flags = c("florabr", "wcvp", "iucn"),
                                    consensus_rule = "all_true")
# Valid (TRUE) when at least one flag is TRUE
occ_consensus_any <- flag_consensus(occ = occ_flagged,
                                    flags = c("florabr", "wcvp", "iucn"),
                                    consensus_rule = "any_true")

}
