% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faunabr_here.R
\name{faunabr_here}
\alias{faunabr_here}
\title{Download the latest version of the Fauna do Brazil (Taxonomic Catalog of the
Brazilian Fauna)}
\usage{
faunabr_here(
  data_dir,
  data_version = "latest",
  solve_discrepancy = TRUE,
  overwrite = TRUE,
  remove_files = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data_dir}{(character) a directory to save the data downloaded from
Fauna do Brazil.}

\item{data_version}{(character) version of the Fauna do Brazil database to
download. Use "latest" to get the most recent version, which is updated
frequently. Alternatively, specify an older version (e.g.,
data_version="1.2"). Default value is "latest".}

\item{solve_discrepancy}{(logical) whether to resolve inconsistencies
between species and subspecies information. When set to TRUE (default),
species information is updated based on unique data from subspecies. For
example, if a subspecies occurs in a certain state, it implies that the
species also occurs in that state.}

\item{overwrite}{(logical) If TRUE, data is overwritten. Default is TRUE.}

\item{remove_files}{(logical) whether to remove the downloaded files used in
building the final dataset. Default is TRUE.}

\item{verbose}{(logical) whether to display messages during function
execution. Set to TRUE to enable display, or FALSE to run silently. Default
is TRUE.}
}
\value{
A message indicating that the data were successfully saved in the directory
specified by \code{data_dir}.
}
\description{
This function downloads the Taxonomic Catalog of the Brazilian Fauna
database, which is required for filtering occurrence records using
specialists' information via the \code{flag_faunabr()} function.
}
\examples{
\donttest{
# Define a directory to save the data
data_dir <- tempdir() # Here, a temporary directory

# Download the latest version of the Flora e Funga do Brazil database
faunabr_here(data_dir = data_dir)
}
}
