% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotSeriesTrendStdDevFromAnalyisObj}
\alias{tsEvaPlotSeriesTrendStdDevFromAnalyisObj}
\title{tsEvaPlotSeriesTrendStdDevFromAnalyisObj}
\usage{
tsEvaPlotSeriesTrendStdDevFromAnalyisObj(
  nonStationaryEvaParams,
  stationaryTransformData,
  trans,
  ...
)
}
\arguments{
\item{nonStationaryEvaParams}{The non-stationary evaluation parameters.}

\item{stationaryTransformData}{The stationary transformed data.}

\item{trans}{The transformation used to fit the EVD, either "ori" (original)
or "rev" (reverse). "inv" and "lninv" are also available}

\item{...}{Additional arguments to customize the plot (optional).}
}
\value{
A ggplot object representing the plot.
}
\description{
\code{tsEvaPlotTrendStdDevFromAnalysisObj}is a function that plots a
time series along with its trend and standard deviation.
}
\examples{
# Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 30 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=1990)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 10*365 # 10 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')
nonStationaryEvaParams <- TSEVA_data[[1]]
stationaryTransformData <- TSEVA_data[[2]]
trans='ori'
result = tsEvaPlotSeriesTrendStdDevFromAnalyisObj(nonStationaryEvaParams,
stationaryTransformData, trans)
result

}
